int StringLength(char str[])
{
  int i;
  i=0;
  while(str[i]) i++;  // wiederhole solange Zeichen nicht Null
  return(i);
}
//------------------------------------------------------------------------------
byte Str_Isnum(char c)
{
    return((c>='0' && c<='9') || (c=='.'));
}
//------------------------------------------------------------------------------
void Str_Mwert(word Wert,word max, byte code)
{
    switch (code)
    {
        case PVLeistung:
            Str_Printf(Zeichenkette," %4u %2s" ,Wert,"W ");
        break;
        case PVSolarspg:
            Str_Printf(Zeichenkette,"%4u %2s" ,Wert,"V ");
        break;
        case PVNetzspg:
            Str_Printf(Zeichenkette,"%7u %2s" ,Wert,"V ");
        break;
        case PVTemp:
            Str_Printf(Zeichenkette,"%2u %3s" ,Wert,"C ");
        break;
        case Datum:
            Str_Printf(Zeichenkette,"%02u %1s %02u %1s %02u" ,day,".",month,".",year);
        break;
        case Zeit:
            Str_Printf(Zeichenkette,"%02u %1s %02u %1s %02u" ,hour,":",minute,":",second);
        break;
        case LaufMinuten:
            Str_Printf(Zeichenkette,"%02u %1s %02u" ,Wert,":",second);
        break;
        case LaufStunden:
            Str_Printf(Zeichenkette,"%02u %1s %02u %1s %02u" ,Wert,":",minute,":",second);
        break;
        case TMP_LM35:
            Str_Printf(Zeichenkette,"%3u %1s %1u %3s" ,Wert/10,".",Wert%10,"C  ");
        break;
        case Wind:
            Str_Printf(Zeichenkette,"%3u %5s" ,Wert,"km/h ");
        break;
        case tWGBdelay:
            Str_Printf(Zeichenkette,"%2u %1s %2u %4s" ,Wert,"/",max,"min ");
        break;
        case tWGBWRtmp:
            Str_Printf(Zeichenkette,"%2u %1s %2u %3s" ,Wert,"/",max,"C  ");
        break;
        case tWGFdelay:
            Str_Printf(Zeichenkette,"%2u %1s %1u %4s" ,Wert,"/",max,"min ");
        break;
        case Zeitformat_hh_mm:
            Str_Printf(Zeichenkette,"%02u %1s %02u" ,Wert,":",max);  // Minuten werden an max bergeben
        break;
        case Zeitformat:
            Str_Printf(Zeichenkette,"%1s %2u %5s" ," ",Wert,": 00 ");
        break;
        case Startzeit:
            Str_Printf(Zeichenkette,"%1s %2u %8s" ," ",Wert,": 00 Uhr");
        break;
        case Laufzeit_h:
            Str_Printf(Zeichenkette,"%1s %2u %2s" ," ",Wert,"h ");
        break;
        case LaufzeitStunden:
            Str_Printf(Zeichenkette,"%1s %2u %8s" ," ",Wert,"Stunden ");
        break;
        case LaufzeitMinuten:
            Str_Printf(Zeichenkette,"%1s %2u %8s" ," ",Wert,"Minuten ");
        break;
        case UTI_Error_txt:
            Str_Printf(Zeichenkette,"%3s %2u %34s" ,"UTI",Wert," Temperaturanschlsse unterbrochen");
        break;
        case DCF_Error_par_txt:
            Str_Printf(Zeichenkette,"%25s %2u" ,"DCF-77 Parityfehler Nr.: ",Wert);
        break;
        case FS20_Error_txt:
            Str_Printf(Zeichenkette,"%13s %2u %6s" ,"FS20 Status: ",Wert," <> 0 ");
        break;
        case RollZeitFenster:
            Str_Printf(Zeichenkette,"%8s %2x %4s" ,"Fenster ",Wert,"sec ");
        break;
        case RollZeitTure:
            Str_Printf(Zeichenkette,"%5s %2x %4s" ,"Tre ",Wert,"sec ");
        break;
        case wordWert:
            Str_Printf(Zeichenkette,"%2u",Wert);
        break;
    }
}
//-----------------------------------------------------------------------------
void Str_Mwertfloat(float Wert, byte TMPmax, byte code)
{
    switch (code)
    {
        case Temp:
            Str_Printf(Zeichenkette,"%3.1f %4s" ,Wert,"C  ");
        break;
        case tWG_TMP:
            Str_Printf(Zeichenkette,"%2.1f %1s %2u %3s" ,Wert,"/",TMPmax,"C  ");
        break;
        case Strom:
            Str_Printf(Zeichenkette,"%2.2f %3s" ,Wert,"A  ");
        break;
        case Leistung:
            Str_Printf(Zeichenkette,"%2.1f %3s" ,Wert,"W  ");
        break;
        case E_Ladung:
            Str_Printf(Zeichenkette,"%2.2f %5s" ,Wert,"kWh  ");
        break;
        case E_ges:
            Str_Printf(Zeichenkette,"%7.1f %5s" ,Wert,"kWh  ");
        break;
        default:
            Str_Printf(Zeichenkette,"%4.1f" ,Wert);
        break;
    }
}
void FLOAT_WERT(float TEMP,byte TMPmax, byte code, word xx, word yy)
{
    Str_Mwertfloat(TEMP,TMPmax,code);

    eDIP_cmd16TXT('Z','L',xx,yy);
}
void WORD_WERT(word wert, word max, byte code, word xx, word yy)
{
    Str_Mwert(wert, max, code);
    eDIP_cmd16TXT('Z','L',xx,yy);
}
