// DCF_RTC: DCF Uhr
// DCF Empfnger erforderlich

// ber den zustzlich erforderlichen DCF Empfnger  wird
// das DCF Signal empfangen.
// Die LED1 blinkt im Sekundentakt.
//------------------------------------------------------------------------------
// Festlegung des Synchronisationszeitpunktes
// in der Interruptroutine

//------------------------------------------------------------------------------
// Festlegung von Startzeit und Startdatum
//

void Time_Init(void)
{
    DCF_synch=0;
    second=0;          // RTC Updatezeit: 01:15:00 siehe Preprozessordefinition
    minute=0;
    hour=0;
    day=0;              // RTC Startdatum:  00.00.2005
    month=0;
    year=5;
}
/**************************************************************************
 DCF77 Library
***************************************************************************/
void DCF_START(void)
{
    BitCounter=0;
    Firstflag=0;
    DCFpar=0;
    ParMin=0; ParHour=0; ParDate=0;
    for(freeCount=0;freeCount<59;freeCount++) DCF_Buffer[freeCount]=0;
    DCF_MODE=1;
    CheckCounter=0;
}
void DCF_PULS(void)  //hier wird auf Vorhandensein eines DCF Signals geprft
{
    if (Port_ReadBit(DCF_IN))   CheckCounter++;        //wenn Signal High Counter erhhen
    else  CheckCounter=0;      //wenn nicht, Counter zurck setzen

    if (CheckCounter==3)  //wenn 3 mal (30ms) HIGH Signal
    {
        DCF_MODE=2;         //dann wird auf DCF_Mode 2 geschaltet
        CheckCounter=0;     //Counter zurck setzen fr andere Routinen
    }
}

void DCF_DATASTART(void)         //hier wird auf die lange Pause im DCF_Signal getriggert
{
         // MODE2 bedeutet: Warten auf 59te Sekunde
    if (Port_ReadBit(DCF_IN)) CheckCounter=0;
    else CheckCounter++;      //wenn kein Signal (0) dann Counter erhhen

    if (CheckCounter>150)
    {
        DCF_MODE=3;        //wenn Signal mindestens 1200ms auf Low
        CheckCounter=0;    //dann DCF_Mode 3 einschalten und Counter auf 0
    }
}


void DCF_COLLECT(void)
{
        if (Port_ReadBit(DCF_IN))   // Wenn wieder eine 1 kommt
        {
            CheckCounter++;                  // dann incr Counter und setze
            if (CheckCounter>2) Firstflag=1; // setze das Flag fr ersten Impuls
        }                                    // nach 30 msec
        else                                //sonst wird der letzte Impuls nach Lnge ausgewertet
        {
            if (Firstflag)       //wenn tatschlich ein Impuls vorhanden WAR
            {
                if (CheckCounter<15)   //schauen ob krzer als 15x10ms
                    DCF_Buffer[BitCounter]=0; //und in diesem Fall den Buffer mit 0 beschreiben

                else DCF_Buffer[BitCounter]=1; //sonst BufferArray mit 1 beschreiben

                Firstflag=0;          //Flag fr vorhandenes DCF Signal lschen
                BitCounter++;            //Counter fr Buffer Array incrementieren

             }
             CheckCounter=0;
         }
         if (BitCounter==59)            //wenn 59 Bits gesammelt wurden
         {
            DCF_MODE=4;                    //DCF_Mode schalten auf Auswertung
            BitCounter=0;                //DCF Arraybufferzhler lschen
         }
}

void DCF_CALC(void)      //wenn DCF_Mode auf Auswertung
{
    byte m_day, m_month, m_year;
    for(freeCount=21;freeCount<=27;freeCount++)
    {
        ParMin=ParMin^DCF_Buffer[freeCount];
    }      //Paritt fr Minuten berechnen

    for (freeCount=29;freeCount<=34;freeCount++)
    {
        ParHour=ParHour^DCF_Buffer[freeCount];
    }       //Paritt fr Stunden berechnen

    for (freeCount=36;freeCount<=57;freeCount++)
    {
        ParDate=ParDate^DCF_Buffer[freeCount];
    }       //Paritt fr Datum berechnen

    if (ParMin!=DCF_Buffer[28]) DCFpar=DCFpar|1;

    if (ParHour!=DCF_Buffer[35]) DCFpar=DCFpar|2;

    if (ParDate!=DCF_Buffer[58]) DCFpar=DCFpar|4;
    // Paritt, Zeit und Datum auf Plausibilitt prfen
    if (DCFpar==0)
    {
        m_minute=(DCF_Buffer[21])+(DCF_Buffer[22]*2)+(DCF_Buffer[23]*4)+(DCF_Buffer[24]*8)+
                (DCF_Buffer[25]*10)+(DCF_Buffer[26]*20)+(DCF_Buffer[27]*40);
        m_hour=(DCF_Buffer[29])+(DCF_Buffer[30]*2)+(DCF_Buffer[31]*4)+(DCF_Buffer[32]*8)+
                (DCF_Buffer[33]*10)+(DCF_Buffer[34]*20);
        m_day=(DCF_Buffer[36])+(DCF_Buffer[37]*2)+(DCF_Buffer[38]*4)+(DCF_Buffer[39]*8)+
                (DCF_Buffer[40]*10)+(DCF_Buffer[41]*20);
        m_month=(DCF_Buffer[45])+(DCF_Buffer[46]*2)+(DCF_Buffer[47]*4)+(DCF_Buffer[48]*8)+
                (DCF_Buffer[49]*10);
        m_year=(DCF_Buffer[50])+(DCF_Buffer[51]*2)+(DCF_Buffer[52]*4)+(DCF_Buffer[53]*8)+
                (DCF_Buffer[54]*10)+(DCF_Buffer[55]*20)+(DCF_Buffer[56]*40)+(DCF_Buffer[57]*80);
       // DCF_MODE=5;
        second=0;

        if (m_month==0 || m_month>12 || m_day==0 || m_day>31 || m_hour>24 || m_minute>60)
        {
            DCF_START();
            Error=Error|DCF_Error;
            if (m_Error==0) m_Error=1;
        }
        else
        {
            if (DCF_synch)   // Check bei Synchronisation
            {
                if (m_hour==hour && (m_year==year || m_year==year+1)) DCF_synch=0;
            }
            if (DCF_synch==0)
            {
                dunkel=200;   // Rolladensteuerung freigeben
                minute=m_minute; hour=m_hour; day=m_day; month=m_month; year=m_year;
                DCF_MODE=5;
                if (month<November && month>=Mrz)     // Teichpumpensteuerung nach Start
                {                                        // im Sommer auf Automatik stellen
                    f_Sommer=1;
                    TeichpAUTOmode=ModeTeichpAUTO; m_TeichpAUTOmode=1;
                }
                else
                {
                    f_Sommer=0;
                    TeichpAUTOmode=ModeTeichpHAND;
                }
                if (month<=August && month>=April) f_R_Sommer=1;
                else f_R_Sommer=0;     // Sommer fr Rollladensteuerung Dachflchen festlegen
            }
            else  DCF_START();
        }
    }
    else
    {
        m_DCFpar=DCFpar;
        DCF_START();
        Error=Error|DCF_Error_parity;
        if (m_Error==0) m_Error=1;
    }
}
void DCF_SECOND (void)
{
    if (Port_ReadBit(DCF_IN))
    {
        DCF_MODE=0;
        second=0;
        DATUM();
        AlarmCheck=EEPROM_Read(e_adr_AL_Check);
    }
}
//------------------------------------------------------------------------------
//  Zeitabgleich
//
void RTC(void)
  {
  second++; f_second++; mRTC=0;
  if (second==60)
  {
    second=0;
    minute++;                                //automatischer Zeitabgleich
    if (hour==DCFupdateStunde && minute==DCFupdateMinute)
    {
        DCF_synch=1;
        DCF_START();
    }
    if (minute==60)
    {
      minute=0;
      hour++;
    if (hour==24) hour=0;
    }
  }
}



