/*** PCF8574_Interface.h ***/
//------------------------------------------------
 #ifndef __PCF8574_INTERFACE__
 #define __PCF8574_INTERFACE__
 #include "LCD_Command.h"
//------------------------------------------------

 #define LCD_TIME_OUT       0x10

/** PCF8574/A I2C bus write address ***/
//  0x40-0x4E : PCF8574   0b 0 1 0 0 A2 A1 A0 0
//  0x70-0x7E : PCF8574A  0b 0 1 1 1 A2 A1 A0 0
 #define I2C_W_ADDR         0x40

//------------------------------------------------
// Definitions for I2C-Bus LC Display-Modul
// C-Control I Art. Nr. 19 83 30
// PCF8574   LC Display
//      P0 = D4  Data Port 4
//      P1 = D5  Data Port 5
//      P2 = D6  Data Port 6
//      P3 = D7  Data Port 7
//      P4 = R/W Read/Write select
//      P5 = RS  Register select
//      P6 = E   LCD enable
//      P7 = BL  Backlight
/*
 #define LCD_READ           0x10
 #define LCD_DATA_REG       0x20
 #define LCD_ENABLE         0x40
 #define LCD_BACKLIGHT      0x80
 #define LCD_BACKLIGHT_ON   0x00
 #define LCD_BACKLIGHT_OFF  0x80
 #define BUSY_FLAG          0x08
 #define LCD_INIT_8_BITS    ((LCD_SET|INTERFACE_8_BITS)>>4)
 #define LCD_INIT_4_BITS    ((LCD_SET|INTERFACE_4_BITS)>>4)
// Use these definitions when the low nibble the data interface is.
 #define LCD_DATA           0x0F
 #define SET_LOW_NIBBLE(a)  (a&0x0F)
 #define GET_LOW_NIBBLE(a)  (a&0x0F)
 #define SET_HIGH_NIBBLE(a) (a>>4)
 #define GET_HIGH_NIBBLE(a) (a<<4)
*/
//------------------------------------------------
// PCF8574   LCD HD44780
//      P0 = RS  Register select
//      P1 = R/W Read/Write select
//      P2 = E   LCD enable
//      P3 = BL  Backlight
//      P4 = D4  Data Port 4
//      P5 = D5  Data Port 5
//      P6 = D6  Data Port 6
//      P7 = D7  Data Port 7

 #define LCD_DATA_REG       0x01
 #define LCD_READ           0x02
 #define LCD_ENABLE         0x04
 #define LCD_BACKLIGHT      0x08
 #define LCD_BACKLIGHT_ON   0x08
 #define LCD_BACKLIGHT_OFF  0x00
 #define BUSY_FLAG          0x80
 #define LCD_INIT_8_BITS    (LCD_SET|INTERFACE_8_BITS)
 #define LCD_INIT_4_BITS    (LCD_SET|INTERFACE_4_BITS)
// Use these definitions when the high nibble the data interface is.
 #define LCD_DATA           0xF0
 #define SET_LOW_NIBBLE(a)  (a<<4)
 #define GET_LOW_NIBBLE(a)  (a>>4)
 #define SET_HIGH_NIBBLE(a) (a&0xF0)
 #define GET_HIGH_NIBBLE(a) (a&0xF0)

//------------------------------------------------
 #endif
//------------------------------------------------