byte fat[SDC_FAT_BUF];                                                          // globale Variablen
byte fil[SDC_FILE_BUF];
dword attrib[4], attr;

byte webmem[WEB_BUF(6)];                                                        // Six Webserver variables
char text[80];                                                                  // "text" string with 80 char
byte ip_info[6];                                                                // IP info array
int cmd, cnt1, cnt2, adc0, adc1, rel1;                                          // Programm variables

int umrechnung(int messwert)
{
    float widerstand;
    int temperatur;

    widerstand = 1400.0/(2048.0/messwert-1);                                    // bei 1400 Ohm Vorwiderstand bei 2048 bit bei 2,048 V Referenz beim AD-Wandler
    temperatur=298*4200/(4200+298*ln(widerstand/4700))-273;                     // Umrechnung Widerstand in Temperatur bei 4700 Ohm NTC und B-Faktor 4200
    return temperatur;
}

void ausgabe(float wert, byte zahl)                                             // Ausgabefunktion
{
    LCD_ClearLCD();                                                             // Display lschen
    LCD_CursorPos(0);                                                           // LCD Cursor positionieren

    switch (zahl)
    {
    case 0:
        LCD_WriteText("Leistung ges.");
        LCD_CursorPos(0x40);
        LCD_WriteFloat(wert,1);
        LCD_WriteText(" kW");
    break;
    case 1:
        LCD_WriteText("Temperatur 1");
        LCD_CursorPos(0x40);
        LCD_WriteFloat(wert,0);
        LCD_WriteChar(223);
        LCD_WriteText("C");
    break;
    case 2:
        LCD_WriteText("Reserve:");
        LCD_CursorPos(0x40);
        LCD_WriteFloat(wert,1);
        LCD_WriteText(" xx");
    break;
    case 3:
        LCD_WriteText("Reserve:");
        LCD_CursorPos(0x40);
        LCD_WriteFloat(wert,1);
        LCD_WriteText(" xx");
    break;
    }
}

void main(void)
{
    byte req_id, min, minute, stunde, sekunde, sek;
    char buf[50];
    byte zahl, tast, tast1, tast2, tast1_x, tast2_x;
    word bytes_written[1];
    float Wert[4];
    int result[4], abtastzeit, phase1, phase2, phase3, adc11, temp;
    tast=0;                                                                     // kein Taster gedrckt
    zahl=0;                                                                     // Men-Anfangsstelle = Wert[0]
    sek=0;
    sekunde=0;
    Wert[0]=0;
    Wert[1]=0;
    Wert[2]=0;
    Wert[3]=0;
    temp=20;
    abtastzeit=0;                                                               // Zeitvariable fr die Abtastzeit, whrend der der Maximalwert gesucht wird
    min=1;
    cmd=0;                                                                      // Set the variable to a start value
    cnt1=20;
    cnt2=0;

    ETH_GetIPInfo(EI_IP_ADDR, ip_info);                                         // IP infomation (Debug window)
    Str_Printf(text, "IP-Adresse: %d.%d.%d.%d\r", ip_info[0], ip_info[1], ip_info[2], ip_info[3]);
    Msg_WriteText(text);
    ETH_GetIPInfo(EI_NETMASK, ip_info);
    Str_Printf(text, "IP-Netmask: %d.%d.%d.%d\r", ip_info[0], ip_info[1], ip_info[2], ip_info[3]);
    Msg_WriteText(text);
    ETH_GetIPInfo(EI_GATEWAY, ip_info);
    Str_Printf(text, "IP-Gateway: %d.%d.%d.%d\r", ip_info[0], ip_info[1], ip_info[2], ip_info[3]);
    Msg_WriteText(text);

    // Start the Webserver at port 80 with six variables
    WEB_StartServer(80, webmem, 6, WEB_CACHE_NORM);

    // Set the five Webserver variables (JSON & CGI)
    WEB_SetDynVar(0, cmd, DYN_INT, DYN_CGIVAR, 0);                              // web request (incoming reference)
    WEB_SetDynVar(1, cnt1, DYN_INT, DYN_JSONVAR, 0);                            // HTML $var1$
    WEB_SetDynVar(2, cnt2, DYN_INT, DYN_JSONVAR, 0);                            // HTML $var2$
    WEB_SetDynVar(3, adc0, DYN_INT, DYN_JSONVAR, 0);                            // HTML $var3$
    WEB_SetDynVar(4, adc1, DYN_INT, DYN_JSONVAR, 0);                            // HTML $var4$
    WEB_SetDynVar(5, rel1, DYN_INT, DYN_JSONVAR, 0);                            // HTML $var5$

    Port_Attribute(PORT_LED2, PORT_ATTR_OUTPUT|PORT_ATTR_INIT_LOW);             // GPIO

    ADC_Disable();
    ADC_SetInput(0, 0, ADC_GND, ADC_SHG_1);                                     // ADC0 aktivieren, Verstrkung = 1 ADC_SetInput(index 0-7, input 0-15, referenz, Verstrkung)
    ADC_SetInput(1, 1, ADC_GND, ADC_SHG_1);                                     // Wandler-Eingnge: ADC_0 (P9) = Phase 1
    ADC_SetInput(2, 2, ADC_GND, ADC_SHG_1);                                     //                   ADC_1 (P10) = Phase 2
    ADC_SetInput(3, 3, ADC_GND, ADC_SHG_1);                                     //                   ADC_2 (P11) = Phase 3
                                                                                //                   ADC_3 (P12) = Reserve
    ADC_Enable(ADC_MODE_12BIT|ADC_MODE_FREE_RUN, 1000000, ADC_ADCREF0, 4, 0);   // 12Bit ADC, free running, 1MHz Abtastfreq., Referenz external, Offset 0
    ADC_Start();

    LCD_Init();                                                                 // Display initialisieren
    LCD_CursorOff();                                                            // Display Cursor ausschalten

    Port_Attribute(PORT_T2, PORT_ATTR_INPUT|PORT_ATTR_PULL_UP);                 // Taster 2-Port als pullup-Input setzen
    Port_Attribute(PORT_T4, PORT_ATTR_INPUT|PORT_ATTR_PULL_UP);                 // Taster 4-Port als pullup-Input setzen
    Port_Attribute(PORT_T5, PORT_ATTR_INPUT|PORT_ATTR_PULL_UP);                 // Taster 5-Port als pullup-Input setzen

    SDC_Init(fat);                                                              // SD-Card initialisieren
    SDC_FOpen(fil, "0:/daten.txt", FA_READ|FA_WRITE|FA_OPEN_ALWAYS);            // Datei ffnen
 //   SDC_FTruncate(fil);                                                         // Datei lschen!!!!! Diese Funktion ausblenden bei Dauerbetrieb!!!
    Clock_SetTime(0,0,0,0);                                                     // Uhr setzen fr Zeitreihe

    Str_Printf(buf, "h:min Leistung in Watt Temperatur in Grad Celsius\r", 0);                                     // Dateikopf formatieren und schreiben
    SDC_FWrite(fil, buf, Str_Len(buf), bytes_written);                          // String in Datei schreiben
    SDC_FSync(fil);                                                             // Puffer in SD-Card schreiben
    SDC_FStat("0:/daten.txt", attrib);                                          // Datei Status lesen : Dateigre in byte ist in attrib[0]
    SDC_FSeek(fil, attrib[0]);                                                  // Setzt den Schreibzeiger auf die nchste Position nach den alten Daten

    while(1)                                                                    // Main loop
    {
        req_id=WEB_GetRequest();
        if(req_id!=0)                                                           // Request?
        {
            Str_Printf(text, "req_id:%d hash:%x cmd:%d cnt1:%d cnt2:%d relay:%d\r", req_id, WEB_GetFileHash(req_id), cmd, cnt1, cnt2, rel1);
            Msg_WriteText(text);                                                // Print infomation
            if(cmd==1)                                                          // cmd value
            {
                cnt1--;                                                         // decrement the cnt1 variable
            }
            if(cmd==2)
            {
                cnt1++;                                                         // increment the cnt1 variable
            }
           if(cmd==3)
           {
                if(rel1==1)                                                     // Switch the Relais/LED on or off
                {
                  rel1=0;
                  Port_WriteBit(PORT_LED2, PORT_OFF);
                }
                else
                {
                  rel1=1;
                  Port_WriteBit(PORT_LED2, PORT_ON);
                }
            }
            if(cnt1>40)cnt1=40;                                               // Limit the cnt1 value to 40
            cmd=0;                                                              // Clear the cmd variable and release request
            WEB_ReleaseRequest(req_id);
        }

        tast2 = Port_ReadBit(PORT_T4);                                          // rauf - Taster
        tast1 = Port_ReadBit(PORT_T5);                                          // runter taster
        if ((tast1 == 0) && (tast1_x == 1))                                     // rauf - Taster
        {
            tast=1;
            if (zahl == 3) { zahl=0; }  else { zahl++; }                        // Menu Punkt eins weiter nach oben setzen (mit berlauf)
        }

        if ((tast2 == 0) && (tast2_x == 1))                                     // runter - Taster
        {
            tast=2;
            if (zahl == 0) { zahl=3; }  else { zahl--; }                        // Menu Punkt eins weiter nach unten setzen (mit berlauf)
        }
        tast1_x = tast1;                                                        // Wert-bergaben fr nchsten Vergleich (Tasterabfrage)
        tast2_x = tast2;
        AbsDelay(30);                                                           // Zeit bis zum nchsten Tasterabfragen

        phase1=0;
        phase2=0;
        phase3=0;
        while (abtastzeit < 500)
        {
            ADC_GetValues(result, 4);                                           // Aufruf der AD-Wandler-Abfrage und bergabe an das result-Array
            if (result[0]>phase1) {phase1=result[0];}                           // Maximalwert suchen
            if (result[1]>phase2) {phase2=result[1];}                           // Maximalwert suchen
            if (result[2]>phase3) {phase3=result[2];}                           // Maximalwert suchen
            abtastzeit++;
        }
        abtastzeit=0;
        Wert[0]=(Wert[0]+phase1+phase2+phase3)/2;                               // addieren und gltten
        Wert[0]=(Wert[0]-20)/340;                                               // Leistung Phasen berechnen   bei 4A Einstellung Messzange
        if (Wert[0]<0) {Wert[0]=0;}

//       Wert[1]=(Wert[1]-3)/39;                                                // Leistung Phasen berechnen   bei 40A Einstellung Messzange
//       Wert[1]=(Wert[1]-1.6)/1;                                               // Leistung Phasen berechnen   bei 400A Einstellung Messzange

        minute=Clock_GetVal(1);                                                 // Zeit aus innerer Uhr abfragen
        stunde=Clock_GetVal(2);
        sekunde=Clock_GetVal(0);
        Wert[1]=temp;
        adc0=temp;                                                              // ADC0 bergabe an Web-Variable
        adc11=Wert[0]*1000;
        adc1=adc11;                                                             // ADC1

        if (sek!=sekunde || (tast > 0))                                         // Men-Ausgabe-Schleife
        {                                                                       // entweder nach ca. 1s oder wenn ein Taster gedrckt wurde
            ausgabe(Wert[zahl], zahl);
            tast=0;
            sek=sekunde;
            temp=umrechnung(result[3]);
        }
        if (min!=minute)                                                        // nach 1 min Wert in SD-Karte schreiben
        {
            Str_Printf(buf, "%d:%d %d %d\r", stunde, minute, adc11, temp);      // String formatieren
            SDC_FWrite(fil, buf, Str_Len(buf), bytes_written);                  // String in Datei schreiben
            SDC_FSync(fil);                                                     // Puffer in SD-Card schreiben
            min=minute;                                                         // Variablen bergabe fr nchste Minute
        }
    }
}


