/*** demo.cc ***/
//------------------------------------------------
void FillEEPROM(void)
    {

// 12 bytes
    EEPROM_Write(0,  0b10000000);
    EEPROM_Write(1,  0b10100000);
    EEPROM_Write(2,  0b10101000);
    EEPROM_Write(3,  0b10101010);
    EEPROM_Write(4,  0b10000000);
    EEPROM_Write(5,  0b11000000);
    EEPROM_Write(6,  0b11100000);
    EEPROM_Write(7,  0b11110000);
    EEPROM_Write(8,  0b11111000);
    EEPROM_Write(9,  0b11111100);
    EEPROM_Write(10, 0b11111110);
    EEPROM_Write(11, 0b11111111);

// 7 bytes
    EEPROM_Write(12, 0b10000001);
    EEPROM_Write(13, 0b01000010);
    EEPROM_Write(14, 0b00100100);
    EEPROM_Write(15, 0b00011000);
    EEPROM_Write(16, 0b00100100);
    EEPROM_Write(17, 0b01000010);
    EEPROM_Write(18, 0b10000001);

// 8 bytes
    EEPROM_Write(19, 0b10000000);
    EEPROM_Write(20, 0b01000000);
    EEPROM_Write(21, 0b00100000);
    EEPROM_Write(22, 0b00010000);
    EEPROM_Write(23, 0b00001000);
    EEPROM_Write(24, 0b00000100);
    EEPROM_Write(25, 0b00000010);
    EEPROM_Write(26, 0b00000001);

// 8 bytes
    EEPROM_Write(27, 0b01111111);
    EEPROM_Write(28, 0b10111111);
    EEPROM_Write(29, 0b11011111);
    EEPROM_Write(30, 0b11101111);
    EEPROM_Write(31, 0b11110111);
    EEPROM_Write(32, 0b11111011);
    EEPROM_Write(33, 0b11111101);
    EEPROM_Write(34, 0b11111110);

// 1 byte
    EEPROM_Write(35, 0b10101010);

// 1 byte
    EEPROM_Write(36, 0b01010101);

// 4 bytes
    EEPROM_Write(37, 0b10000001);
    EEPROM_Write(38, 0b10000001);
    EEPROM_Write(39, 0b10000001);
    EEPROM_Write(40, 0b10000001);

    }
//------------------------------------------------
 void CheckEEPROM(void)
    {
    word w_eeprom_addr;

    for(w_eeprom_addr = 0; w_eeprom_addr <= 40; w_eeprom_addr++)
        {
        Msg_WriteHex(EEPROM_Read(w_eeprom_addr));
        Msg_WriteChar(13);
        Thread_Delay(1);
        }

    }
//------------------------------------------------
 void main(void)
    {

    FillEEPROM();
    CheckEEPROM();
    BitSequenceInitTimer();
    BitSequenceInitAsm();

    while(1)
        {

        BitSequenceTimer(0, 12);
        Thread_Delay(500);
        BitSequenceSimple(0, 12);
        Thread_Delay(500);
        BitSequenceAsm(0, 12);
        Thread_Delay(500);

        BitSequenceTimer(12, 7);
        Thread_Delay(500);
        BitSequenceSimple(12, 7);
        Thread_Delay(500);
        BitSequenceAsm(12, 7);
        Thread_Delay(500);

        BitSequenceTimer(19, 8);
        Thread_Delay(500);
        BitSequenceSimple(19, 8);
        Thread_Delay(500);
        BitSequenceAsm(19, 8);
        Thread_Delay(500);

        BitSequenceTimer(27, 8);
        Thread_Delay(500);
        BitSequenceSimple(27, 8);
        Thread_Delay(500);
        BitSequenceAsm(27, 8);
        Thread_Delay(500);

        BitSequenceTimer(35, 1);
        Thread_Delay(500);
        BitSequenceSimple(35, 1);
        Thread_Delay(500);
        BitSequenceAsm(35, 1);
        Thread_Delay(500);

        BitSequenceTimer(36, 1);
        Thread_Delay(500);
        BitSequenceSimple(36, 1);
        Thread_Delay(500);
        BitSequenceAsm(36, 1);
        Thread_Delay(500);

        BitSequenceTimer(37, 4);
        Thread_Delay(500);
        BitSequenceSimple(37, 4);
        Thread_Delay(500);
        BitSequenceAsm(37, 4);
        Thread_Delay(500);

        BitSequenceTimer(0, 40);
        Thread_Delay(500);
        BitSequenceSimple(0, 40);
        Thread_Delay(500);
        BitSequenceAsm(0, 40);
        Thread_Delay(500);
        }
    }
//------------------------------------------------

