;*** BitSequence-0.03.asm ***;
;-------------------------------------------------
 .include "cpu128def.inc"
 .include "RegDef.inc"
;-------------------------------------------------
; 1 / 14745600 Hz = 6,78e-8 s = 1 cpu tick
; 500s = 0.000 5 s / 6,78e-8 =  7372,8 cpu ticks
; 7372 = 0x1CCC
;-------------------------------------------------
 .ifdef TagStartTimer1A
 StartTimer1A:

    in    R_DATA_LOW,    SREG
    cli

; Set OCR1AH and OCR1AL - Output Compare Register 1 A.
    ldi   R_TEMP_LOW,    0x1C
    ldi   R_TEMP_HIGH,   0xCC
    out   OCR1AH,        R_TEMP_LOW
    out   OCR1AL,        R_TEMP_HIGH

; Set TCCR1A - Timer/Counter1 Control Register A.
    ldi   R_TEMP_LOW,    0x00
    out   TCCR1A,        R_TEMP_LOW

; Set TCCR3B - Timer/Counter3 Control Register B.
    ldi   R_TEMP_LOW,    (1 << WGM12) | (1 << CS10)
    out   TCCR1B,        R_TEMP_LOW

; TIMSK - Timer/Counter Interrupt Mask Register
    ;ldi   R_TEMP_LOW,    (1 << OCIE1A)
    ;out   TIMSK,         R_TEMP_LOW

    out   SREG,          R_DATA_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagBitSequenceAsm
 BitSequenceAsm:

    in    R_DATA_LOW,    SREG
    cli

; move parameter stack pointer into Z
    movw  R_ZP_LOW,      R_PARAM_LOW

; load 2nd parameter (w_bytes_count) into R_COUNT
    ld    R_COUNT_LOW,   Z+
    ld    R_COUNT_HIGH,  Z+

; load 1st parameter (w_eeprom_address) into X
    ld    R_XP_LOW,      Z+
    ld    R_XP_HIGH,     Z
; first 32 bytes are used by the system
    adiw  R_XP_LOW,      32

; Wait for completion of previous write
 BIT_SEQUENCE_EEPROM_READ:
    sbic  EECR,          EEWE
    rjmp  BIT_SEQUENCE_EEPROM_READ

 BIT_SEQUENCE_WAIT_1:
    in    R_TEMP_LOW,    TIFR
    sbrs  R_TEMP_LOW,    OCF1A
    rjmp  BIT_SEQUENCE_WAIT_1
    ldi   R_TEMP_LOW,    (1 << OCF1A)
    out   TIFR,          R_TEMP_LOW

 BIT_SEQUENCE_LOOP_BYTES:

; Set up address (R_XP_HIGH:R_XP_LOW) in address register
    out   EEARH,         R_XP_HIGH
    out   EEARL,         R_XP_LOW

; Start eeprom read by writing EERE
    sbi   EECR,          EERE

; Read data from data register
    in    R_DATA_HIGH,   EEDR

    ldi   R_ZP_LOW,      128
 BIT_SEQUENCE_LOOP_BITS:
    mov   R_TEMP_HIGH,   R_DATA_HIGH

 BIT_SEQUENCE_WAIT_2:
    in    R_TEMP_LOW,   TIFR
    sbrs  R_TEMP_LOW,   OCF1A
    rjmp  BIT_SEQUENCE_WAIT_2
    ldi   R_TEMP_LOW,   (1 << OCF1A)
    out   TIFR,          R_TEMP_LOW

; Z is set if the result is $00, cleared otherwise.
    and   R_TEMP_HIGH,   R_ZP_LOW ; 1 cycle

; Test the Zero flag (Z) and branches if Z is cleared.
; Cycles:
;   1 if condition is false
;   2 if condition is true
    brne  BIT_SEQUENCE_SET_BIT    ; 1 or 2 cycle
    nop
    cbi   PORTC,         PORTC5
    rjmp  BIT_SEQUENCE_NEXT_BIT   ; 2 cycle
 BIT_SEQUENCE_SET_BIT:
    sbi   PORTC,         PORTC5
 BIT_SEQUENCE_NEXT_BIT:

; repeat BIT_SEQUENCE_LOOP_BITS if R_ZP_LOW is not zero
    lsr   R_ZP_LOW
    brne  BIT_SEQUENCE_LOOP_BITS

; next eeprom address
    adiw  R_XP_LOW,      1

; repeat BIT_SEQUENCE_LOOP_BYTES if R_COUNT is not zero
    sbiw  R_COUNT_LOW,   1
    brne  BIT_SEQUENCE_LOOP_BYTES

; wait until last bit is complete
 BIT_SEQUENCE_WAIT_3:
    in    R_TEMP_LOW,    TIFR
    sbrs  R_TEMP_LOW,    OCF1A
    rjmp  BIT_SEQUENCE_WAIT_3
    ldi   R_TEMP_LOW,   (1 << OCF1A)
    out   TIFR,          R_TEMP_LOW

; set portbit PORTC5 low
    nop
    nop
    nop
    cbi   PORTC,         PORTC5

    out   SREG,          R_DATA_LOW
    ret
 .endif
;-------------------------------------------------
 .ifdef TagGlobalInterruptDisable
 GlobalInterruptDisable:

 ; Branch if interrupt enabled
    brie  GLOBAL_INTERRUPT_IS_ENABLED
    ldi   R_TEMP_LOW,    0x00
    rjmp  GLOBAL_INTERRUPT_IS_DISABLED
 GLOBAL_INTERRUPT_IS_ENABLED:
    ldi   R_TEMP_LOW,    0x01
 GLOBAL_INTERRUPT_IS_DISABLED:

; Clear Global Interrupt Flag
    cli

; copy stack pointer
    movw  R_ZP_LOW,      R_SP_LOW

; add 4 to sp
    adiw  R_ZP_LOW,      0x04

; copy back to stack pointer location
    movw  R_SP_LOW,      R_ZP_LOW

; store byte value on stack
    st    Z+,            R_TEMP_LOW

; only for the case, the user stores the value in a bigger data type
    clr   R_TEMP_LOW
    st    Z+,            R_TEMP_LOW
    st    Z+,            R_TEMP_LOW
    st    Z,             R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagGlobalInterruptEnable
 GlobalInterruptEnable:

; Set Global Interrupt Flag
    sei

    ret
 .endif
;-------------------------------------------------