/*** BitSequence-0.03.cc ***/
//------------------------------------------------
 #define BOOL   byte
 #define OUTPUT 0x15
 #define LOCK   1
 #define UNLOCK 0
//------------------------------------------------
 BOOL GlobalInterruptDisable $asm("TagGlobalInterruptDisable") (void);
 void GlobalInterruptEnable  $asm("TagGlobalInterruptEnable")  (void);
 void BitSequenceAsm         $asm("TagBitSequenceAsm") (word w_eeprom_address, word w_bytes_count);
 void StartTimer1A           $asm("TagStartTimer1A")   (void);
//------------------------------------------------
 word gw_eeprom_addr;
 word gw_eeprom_end;
 byte gby_eeprom_data;
 byte gby_bit_mask;
 byte gby_bit_value;
 byte gby_timer_stop;
//------------------------------------------------
 void Timer3ClockAlarm(void)
    {
    Port_WriteBit(OUTPUT, gby_bit_value);

    if(gby_timer_stop)
        Timer_T3Stop();

    if(!gby_bit_mask)
        {

        if(gw_eeprom_addr >= gw_eeprom_end)
            {
            gby_timer_stop = true;
            gby_bit_value = 0;
            Irq_GetCount(INT_TIM3CMPA);
            return;
            }

        gby_bit_mask    = 0x80;
        gby_eeprom_data = EEPROM_Read(gw_eeprom_addr);
        gw_eeprom_addr++;
        }

    gby_bit_value = (gby_bit_mask & gby_eeprom_data);
    gby_bit_mask  = (gby_bit_mask >> 1);

    Irq_GetCount(INT_TIM3CMPA);
    }
//------------------------------------------------
 void BitSequenceTimer(word w_eeprom_addr, byte by_bytes_count)
    {
    gw_eeprom_addr  = w_eeprom_addr;
    gw_eeprom_end   = (w_eeprom_addr + by_bytes_count);
    gby_bit_mask    = 0;
    gby_eeprom_data = 0;
    gby_bit_value   = 0;
    gby_timer_stop  = false;

    Timer_T3Start(PS_1);
    }
//------------------------------------------------
 void BitSequenceSimple(word w_eeprom_addr, byte by_bytes_count)
    {
    word w_temp_addr;
    word w_eeprom_end;
    byte by_eeprom_data;
    byte by_bit_mask;
    byte by_global_interrupt_status;
    int  i_wait;

    Thread_Lock(LOCK);
    by_global_interrupt_status = GlobalInterruptDisable();
    w_eeprom_end = (w_eeprom_addr + by_bytes_count);
    for(w_temp_addr = w_eeprom_addr; w_temp_addr < w_eeprom_end; w_temp_addr++)
        {
        by_eeprom_data = EEPROM_Read(w_temp_addr);
        by_bit_mask    = 0x80;
        while(by_bit_mask)
            {
            if(by_bit_mask & by_eeprom_data)
                Port_WriteBit(OUTPUT, 1);
            else
                Port_WriteBit(OUTPUT, 0);

            by_bit_mask = (by_bit_mask >> 1);

            for(i_wait = 0; i_wait < 9; i_wait++);
            i_wait++;
            }
        }
    Port_WriteBit(OUTPUT, 0);
    if(by_global_interrupt_status)
        GlobalInterruptEnable();
    Thread_Lock(UNLOCK);
    }
//------------------------------------------------
 void BitSequenceInitTimer(void)
    {
// 1 / 14745600 Hz = 6,78e-8 s = 1 cpu tick
// 500s = 0.000 5 s / 6,78e-8 =  7372,8 cpu ticks
// 7372 = 0x1CCC
    Timer_T3Time(0x1CCC, PS_1);
    Timer_T3Stop();

    Port_DataDirBit(OUTPUT, PORT_OUT);
    Port_WriteBit(OUTPUT, 0);
    Irq_SetVect(INT_TIM3CMPA, Timer3ClockAlarm);
    }
//------------------------------------------------
 void BitSequenceInitAsm(void)
    {
    StartTimer1A();
    Port_DataDirBit(OUTPUT, PORT_OUT);
    Port_WriteBit(OUTPUT, 0);
    }
//------------------------------------------------




