int bfly_buff[FFT_N*2]; // FFT_N is the number of samples, defined in FFT.cc.
word T1, T2, T3;
char txt[60];

void main(void)
{
    Timer_T0FRQ(208,PS0_256); // Generate 138.462 Hz sound on speaker. This
    // will be more or less a square wave.

    Thread_Delay(10); // Wait for speaker to start up.

    ADC_Set(ADC_VREF_BG, ADC3); // Select reference voltage and input channel.
    // (The sample rate defaults to 8861.536 sps.)

    FFT_Input();
    // Hamming windowed input from AD converter in Free Running Mode.
    ADC_Disable(); // Disable AD converter.

    FFT_Execute();// Butterfly operations on sampled wave form.

    FFT_Output(); // Conversion of results of butterfly operations to spectrum.

    // Write benchmark results
    Str_Printf(txt, "fft_input %.1fms \r", T1 * 0.00434);
    Msg_WriteText(txt);
    Str_Printf(txt, "fft_execute %.1fms \r", T2 * 0.00434);
    Msg_WriteText(txt);
    Str_Printf(txt, "fft_output %.1fms \r", T3 * 0.00434);
    Msg_WriteText(txt);
}

void FFT_Input(void)
{
    int temp_array[FFT_N]; // Used to give asm function access to table in flash

    temp_array=tbl_window;

    Timer_T1Time(65000,3); // Start benchmark, 542.5 ns ticks.
    fft_input(bfly_buff, temp_array, 2); // decimate = 2. This means that the
    // actual sample rate is 8861.54/2 = 4430.77 sps.
    T1=Timer_T1GetCNT()-3; // Benchmark with correction factor.

    Show_buffer(bfly_buff, FFT_N*2); // Display the waveform.
    // Note that every value is recorded twice.
}

void FFT_Execute(void)
{
    int temp_array[FFT_N]; // Used to give asm function access to table in flash

    temp_array=tbl_cos_sin;

    Timer_T1Time(65000,3); // Start benchmark, 542.5 ns ticks.
    fft_execute(bfly_buff, temp_array);
    T2=Timer_T1GetCNT()-3; // Benchmark with correction factor.
}

void FFT_Output(void)
{
    int temp_array[FFT_N/2];
    // Used to give asm function access to table in flash and to store the
    // spectrum.

    temp_array=tbl_bitrev;

    Timer_T1Time(65000,3); // Start benchmark, 542.5 ns ticks.
    fft_output(bfly_buff, temp_array);
    T3=Timer_T1GetCNT()-3; // Benchmark with correction factor.

    Show_buffer(temp_array, FFT_N/2);
    // The frequency scale is obtained by multiplying the spectrum array index
    // with sample rate/FFT_N.
    // With a sample rate (after decimation) of 4430.77 sps the frequency of
    // the generated sound (138.462 Hz) equals sample rate/32. This means that
    // the main peak falls on index FFT_N/32.
    // Index 0 contains the DC component of the wave form.
}

void Show_buffer(int p_buffer[], word count)
{
    int i_index;

    Msg_WriteText("y=[");

    for(i_index = 0; i_index < count; i_index++)
    {
        Msg_WriteInt(p_buffer[i_index]);

        if((i_index+1) % 12)
            Msg_WriteText("; ");
        else
            Msg_WriteText(";\r   ");
    }
    Msg_WriteText("];\r");
}


