////////////////////////////////////////////////////////////////////////////////
/////////////// Betrieblicher Auftrag 2010/11 von Florian Krmer ///////////////
////////////////////////////////////////////////////////////////////////////////
//Projekt: Kittest PROTRAC-KLEMP3 //////////////////////////////////////////////
//Funktion: Hauptprogramm //////////////////////////////////////////////////////
//Language: Compact C //////////////////////////////////////////////////////////
//Controller: C-Control PRO MEGA32 /////////////////////////////////////////////
//Ersteller: KraemerF //////////////////////////////////////////////////////////
//Erstellt: 31.01.2011 /////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

// Ports definiereen

// 0 = PORT A, 1 = PORT B, 2 = PORT C, 3 = PORT D

#define PORT_A 0
#define PORT_B 1
#define PORT_C 2
#define PORT_D 3

//******************************************************************************

//Ausgnge definieren
#define LED_ok 0x01
#define LED_fail 0x02
#define K17 0x04
#define K18 0x08

//******************************************************************************


//LCD Pins definieren
#define Enable 19
#define RS 18
#define D4 20
#define D5 21
#define D6 22
#define D7 23

//******************************************************************************

//Porterweiterung PE1 definieren, alle Jumper mssen gesteckt sein.
#define PE1 0x40

#define K1 0x01
#define K2 0x02
#define K3 0x04
#define K4 0x08
#define K5 0x10
#define K6 0x20
#define K7 0x40
#define K8 0x80

//Porterweiterung PE2, Jumper A0 muss gezogen, A1 und A2 gesteckt sein.
#define PE2 0x42

#define K9  0x01
#define K10 0x02
#define K11 0x04
#define K12 0x08
#define K13 0x10
#define K14 0x20
#define K15 0x40
#define K16 0x80

//Porterweiterung PE3, Jumper A0 und A2 muss gezogen, A1 gesteckt sein.
#define PE3 0x44

#define K19 0x01
#define K20 0x02
#define K21 0x04
#define K22 0x08

//******************************************************************************

//Variablen anlegen

char fehler1[10];
byte first;
byte Kalibrierung_Start;
byte Kalibrierung;
byte start;
byte stop;
byte pruefung;
byte fertig;
byte KLEMP3;
byte KLEMP3CX;
int F,F1;
int i;
float U_AD0,U_AD1,U_AD2,U_AD3,U_AD4,U_AD5,U_AD6,U_AD7;
float wert;
float ergebnis;
float endergebnis;
float I_Varistor;

//*****************************************************************************

//Hauptprogramm

void main(void)
{
    Init();

    clearLCD_setLCDzeile1pos1();
    Text = "   KITTESTER";                      //auszugebender Text
    send1_pos2();                               //Text Position 1 senden, Cursor an Position 2 setzen


    if(Port_ReadBit(29)==true)                  //Auswahlschalter wird abgefragt, damit das richtige Programm ausgefhrt wird
    {
        Text = "PROTRAC-KLEMP3";                //normale Version, kein Stromausgang
        KLEMP3=true;
        KLEMP3CX=false;
    }
    else
    {
        Text = "PROTRAC-KLEMP3CX";              //EX-Version, Stromausgang ist vorhanden
        KLEMP3CX=true;
        KLEMP3=false;
    }

    LCD_Write_Text_Ext();                       //Text schreiben
    first=true;                                 //Erster Durchgang
    AbsDelay(2000);                             //Verzgerung in ms

//******************************************************************************

//Kalibrierung

    while(Port_ReadBit(28)==true)               //Kalibrierung Starten?
    {
        i++;
        AbsDelay(10);
        if(i>200)                               //Taster muss lnger als 2 Sekunden gedrckt werden
        {
            Kalibrierung_Start=true;
        }
    }
    if(Kalibrierung_Start==true)                //Prfschritte Kalibrierung
    {
        while(1)
        {
            clearLCD_setLCDzeile1pos1();
            Text = "Kalibrierung";
            LCD_Write_Text_Ext();
            AbsDelay(2000);

            Ps_Kal1();
            Read_AD7();

            AbsDelay(2000);

            Ps_Kal2();
            Read_AD7();

            AbsDelay(2000);


            Ps_Kal3();
            Read_AD7();

            AbsDelay(2000);
        }
    }

//******************************************************************************

//Prfschritte

    while(1)
    {
        if(first==true)                             //Schleife wird nur beim ersten Durchgang geffnet
        {
        clearLCD_setLCDzeile1pos1();
        Text = "Kontaktieren und";                  //auszugebender Text
        send1_pos2();                               //Text Position 1 senden, Cursor an Position 2 setzen
        Text = "Start druecken";                    //auszugebender Text
        LCD_Write_Text_Ext();                       //Text schreiben
        first=false;
        }

        do                                          //Solange Start nicht gedrckt ist Schleife ausfhren
        {
            if(Port_ReadBit(26)==false)
            {
                start = true;
            }

        } while(start==false);                      //Solange Start nicht gedrckt ist Schleife ausfhren

        Init();

        do                                          //Solange die Prfung nicht beendet ist Schleife ausfhren
        {

//******************************************************************************

//Programmauswahl
// Es wird berprft, ob das richtige Programm zur richtigen Elektronik ausgewhlt wurde
/*
            if(Port_ReadBit(29)==true)              //Abfrage KLEMP3
            {
                KLEMP3=true;
                KLEMP3CX=false;
            }
            else                                    //Abfrage KLEMP3.CX
            {
                KLEMP3CX=true;
                KLEMP3=false;
            }


            if (KLEMP3==true)                       //Es kann theoretisch eine EX-Elektronik mit dem normalen Programm getestet werden.
            {                                       //deshalb wird bei dem normalen Programm getestet, ob der Stromausgang (Klemme1) nicht bestckt ist.
                startI2C_PE1();                     //Ist er bestckt, ist es eine EX-Elektronik und somit ist das falsche Programm ausgewhlt.
                I2C_Write(0x30);                    //K5 und K6 schlieen
                Read_AD5();
                Read_AD6();
                A_PR();

                if(pruefung==false)
                {
                    F=16;
                    break;
                }
            }
*/
            if(Port_ReadBit(29)==false)
            {
                pruefung=false;
                F=17;
                break;
            }
            else
            {
                pruefung=false;
                F=16;
                break;
            }



//******************************************************************************

//Prfschritte Durchgangsprfung


            PS1();                                  //Prfschritt 1 aufrufen
            read_AD1_to_AD6();
            //U_Out();                              //Spannungswerte ausgeben
            A_DGP_GND();                            //Auswertung aufrufen
            if(pruefung==false)                     //Fals Prfung nicht bestanden diese Schleife ausfhren
            {
                F=1;                                //Grund des Fehlers bestimmen
                break;                              //Schleife abbrechen
            }

            PS2();                                  //Prfschritt 2 aufrufen
            read_AD1_to_AD6();
            //U_Out();                              //Spannungswerte ausgeben
            A_DGP_GND();                            //Auswertung aufrufen
            if(pruefung==false)                     //Fals Prfung nicht bestanden diese Schleife ausfhren
            {
                F=2;                                //Grund des Fehlers bestimmen
                break;
            }

            PS3();                                  //Prfschritt 3 aufrufen
            read_AD1_to_AD6();
            //U_Out();                              //Spannungswerte ausgeben
            A_DGP_3V3();                            //Auswertung aufrufen
            if(pruefung==false)                     //Fals Prfung nicht bestanden diese Schleife ausfhren
            {
                F=3;                                //Grund des Fehlers bestimmen
                break;
            }

            PS4();                                  //Prfschritt 4 aufrufen
            read_AD1_to_AD6();
            //U_Out();                              //Spannungswerte ausgeben
            A_DGP_3V3();                            //Auswertung aufrufen
            if(pruefung==false)                     //Fals Prfung nicht bestanden diese Schleife ausfhren
            {
                F=4;                                //Grund des Fehlers bestimmen
                break;
            }

            PS5();                                  //Prfschritt 5 aufrufen
            read_AD1_to_AD6();
            //U_Out();                              //Spannungswerte ausgeben
            A_DGP_SCL();                            //Auswertung aufrufen
            if(pruefung==false)                     //Fals Prfung nicht bestanden diese Schleife ausfhren
            {
                F=5;                                //Grund des Fehlers bestimmen
                break;
            }
            PS6();                                  //Prfschritt 6 aufrufen
            read_AD1_to_AD6();
            //U_Out();                              //Spannungswerte ausgeben
            A_DGP_SCL();                            //Auswertung aufrufen
            if(pruefung==false)                     //Fals Prfung nicht bestanden diese Schleife ausfhren
            {
                F=6;                                //Grund des Fehlers bestimmen
                break;
            }

            PS7();                                  //Prfschritt 7 aufrufen
            read_AD1_to_AD6();
            //U_Out();                              //Spannungswerte ausgeben
            A_DGP_SDA();                            //Auswertung aufrufen
            if(pruefung==false)                     //Fals Prfung nicht bestanden diese Schleife ausfhren
            {
                F=7;                                //Grund des Fehlers bestimmen
                break;
            }

            PS8();                                  //Prfschritt 8 aufrufen
            read_AD1_to_AD6();
            //U_Out();                              //Spannungswerte ausgeben
            A_DGP_SDA();                            //Auswertung aufrufen
            if(pruefung==false)                     //Fals Prfung nicht bestanden diese Schleife ausfhren
            {
                F=8;                                //Grund des Fehlers bestimmen
                break;
            }

            if(KLEMP3CX==true)
            {
                PS9();                              //Prfschritt 9 aufrufen
                read_AD1_to_AD6();
                //U_Out();                          //Spannungswerte ausgeben
                A_DGP_BU2_2();                      //Auswertung aufrufen
                if(pruefung==false)                 //Fals Prfung nicht bestanden diese Schleife ausfhren
                {
                    F=9;                            //Grund des Fehlers bestimmen
                    break;
                }

                PS10();                             //Prfschritt 10 aufrufen
                read_AD1_to_AD6();
                //U_Out();                          //Spannungswerte ausgeben
                A_DGP_BU2_2();                      //Auswertung aufrufen
                if(pruefung==false)                 //Fals Prfung nicht bestanden diese Schleife ausfhren
                {
                    F=10;                           //Grund des Fehlers bestimmen
                    break;
                }

                PS11();                             //Prfschritt 10 aufrufen
                read_AD1_to_AD6();
                //U_Out();                          //Spannungswerte ausgeben
                A_DGP_BU2_1();                      //Auswertung aufrufen
                if(pruefung==false)                 //Fals Prfung nicht bestanden diese Schleife ausfhren
                {
                    F=11;                           //Grund des Fehlers bestimmen
                    break;
                }
                PS12();                             //Prfschritt 12 aufrufen
                read_AD1_to_AD6();
                //U_Out();                          //Spannungswerte ausgeben
                A_DGP_BU2_1();                      //Auswertung aufrufen
                if(pruefung==false)                 //Fals Prfung nicht bestanden diese Schleife ausfhren
                {
                    F=12;                           //Grund des Fehlers bestimmen
                    break;
                }
            }

            AbsDelay(200);

//******************************************************************************

//Prfschritte Varistor-Test

            Init_Ports();

            PS13();
            //I_Out();
            //Auswertung_Varistor_Test();
            if(pruefung==false)                     //Fals Prfung nicht bestanden diese Schleife ausfhren
            {
               F=13;                                //Grund des Fehlers bestimmen
               break;
            }

            PS14();
            //I_Out();
            //Auswertung_Varistor_Test();
            if(pruefung==false)                     //Fals Prfung nicht bestanden diese Schleife ausfhren
            {
                F=14;                               //Grund des Fehlers bestimmen
                break;
            }

            PS15();
            //I_Out();
            //Auswertung_Varistor_Test();
            if(pruefung==false)                     //Fals Prfung nicht bestanden diese Schleife ausfhren
            {

                F=15;                               //Grund des Fehlers bestimmen
                break;
            }

            fertig = true;


        } while(fertig ==false);                    //Solange die Prfung nicht beendet ist Schleife ausfhren

//******************************************************************************

//Auswertung Prfung ok oder fail

        if(fertig == true)                          //Fals die Prfung beendet wurde Schleife ausfhren
                {
                Port_DataDir(PORT_B,0xFF);          //Port_B als Ausgang deklarieren
                Port_Write(PORT_B,LED_ok);          //LED-ok anschalten

                clearLCD_setLCDzeile1pos1();
                Text = "Pruefung";
                send1_pos2();                       //Text Position 1 senden, Cursor an Position 2 setzen
                Text = "bestanden";
                LCD_Write_Text_Ext();               //Text schreiben

                AbsDelay(1000);                     //Verzgerung in ms

                clearLCD_setLCDzeile1pos1();
                Text = "Start druecken";            //auszugebender Text
                send1_pos2();                       //Text Position 1 senden, Cursor an Position 2 setzen
                Text = "um neuzustarten";           //auszugebender Text
                LCD_Write_Text_Ext();               //Text schreiben

                }

            else if (pruefung == false)             //Fals Prfung nicht beendet wurde Schleife ausfhren
                {
                Port_DataDir(PORT_B,0xFF);          //Port_B als Ausgang deklarieren
                Port_Write(PORT_B,LED_fail);        //LED-fail anschalten

                Fehler_Out();                       //Fehler-Ausgabe
                }
    }

}


//******************************************************************************

//Funktionen

void clearLCD_setLCDzeile1pos1 (void)               //LCD-Lschen und Cursor an Position 1 setzen
{
    LCD_CLEAR();
    LCD_Locate_Ext(1,1);                            //Zeile 1, Pos 1
}

void send1_pos2 (void)                              //Text Position 1 senden, Cursor an Position 2 setzen
{
    LCD_Write_Text_Ext();                           //Text schreiben
    LCD_Locate_Ext(2,1);                            //Zeile 2, Pos 1
}


void read_AD1_to_AD6(void)
{
    Read_AD1();
    Read_AD2();
    Read_AD3();
    Read_AD4();
    Read_AD5();
    Read_AD6();
}
