/*** main.cc ***/
//------------------------------------------------
// This example code demonstrates how the system clock could be set with the aid
// of the DCF77 module. Is the DCF77-signal without error, it will be used to show
// the time in a LCD-display. In the other case, when the DCF77-signal is faulty,
// the system-time is automatic used.
//------------------------------------------------
 #include "DCF77.h"
 #thread 0, 0, 100
 #thread THREAD_NUMBER_DCF77, 128, 100
//------------------------------------------------
 void GetSystemTime(char pc_buffer[])
    {
    byte by_clock;
    by_clock = Clock_GetVal(CLOCK_DAY);
    by_clock++;
    pc_buffer[0] = HI_CHAR(by_clock);
    pc_buffer[1] = LOW_CHAR(by_clock);
    pc_buffer[2] = '-';
    by_clock = Clock_GetVal(CLOCK_MON);
    by_clock++;
    pc_buffer[3] = HI_CHAR(by_clock);
    pc_buffer[4] = LOW_CHAR(by_clock);
    pc_buffer[5] = '-';
    pc_buffer[6] = '2';
    pc_buffer[7] = '0';
    by_clock = Clock_GetVal(CLOCK_YEAR);
    pc_buffer[8] = HI_CHAR(by_clock);
    pc_buffer[9] = LOW_CHAR(by_clock);
    pc_buffer[10] = ' ';
    by_clock = Clock_GetVal(CLOCK_HOUR);
    pc_buffer[11] = HI_CHAR(by_clock);
    pc_buffer[12] = LOW_CHAR(by_clock);
    pc_buffer[13] = ':';
    by_clock = Clock_GetVal(CLOCK_MIN);
    pc_buffer[14] = HI_CHAR(by_clock);
 	pc_buffer[15] = LOW_CHAR(by_clock);
    pc_buffer[16] = ':';
    by_clock = Clock_GetVal(CLOCK_SEC);
    pc_buffer[17] = HI_CHAR(by_clock);
    pc_buffer[18] = LOW_CHAR(by_clock);
    pc_buffer[19] = ' ';
    pc_buffer[20] = 'C';
    pc_buffer[21] = 'P';
    pc_buffer[22] = 'U';
    pc_buffer[23] = 0;
    }
//------------------------------------------------
 void TimeToIDE(char pc_time[])
    {
    Msg_WriteText(pc_time);
    Msg_WriteText("\r");
    }
//------------------------------------------------
 void TimeToSerialPort(char pc_time[])
    {
    int i_index;
    i_index = 0;
    while(pc_time[i_index])
        Serial_Write(0, pc_time[i_index++]);
    Serial_Write(0, 0x0A);
    Serial_Write(0, 0x0D);
    }
//------------------------------------------------
 void TimeToLCD(char pc_time[])
    {
    int i_index;
    i_index = 0;
    LCD_ClearLCD();
    LCD_CursorPos(0);
    for(i_index = 0; i_index < 6; i_index++)
        LCD_WriteChar(pc_time[i_index]);
    LCD_WriteChar(pc_time[8]);
    LCD_WriteChar(pc_time[9]);
    LCD_CursorPos(0x40);
    for(i_index = 11; i_index < 19; i_index++)
        LCD_WriteChar(pc_time[i_index]);
    }
//------------------------------------------------
 void main(void)
    {
    char sz_time[MSG_LENGTH];
    Serial_Init(
        0,
        SR_8BIT | SR_1STOP | SR_NO_PAR,
        SR_BD9600
        );
    LCD_Init();
    DCF77Init();
    while(1)
        {
        if(g_by_dcf77_error)
            GetSystemTime(sz_time);
        else
            DCF77TimeAsString(sz_time);
        TimeToIDE(sz_time);
        TimeToSerialPort(sz_time);
        TimeToLCD(sz_time);
        Thread_Delay(100);
        }
    }
//------------------------------------------------