/*** StringContainer-0.01.cc ***/
//------------------------------------------------
 int InitContainer    $asm("TagInitContainer")     (char p_container[], word w_size);
 int ClearContainer $asm("TagClearContainer") (char p_container[]);
 int PushString          $asm("TagPushString")        (char p_container[], char p_string[]);
 int PopString           $asm("TagPopString")          (char p_container[]);
 int UnshiftString     $asm("TagUnshiftString")    (char p_container[], char p_string[]);
 int ShiftString         $asm("TagShiftString")         (char p_container[]);
 int InsertString       $asm("TagInsertString")       (char p_container[], char p_string[], word w_position);
 int DeleteString      $asm("TagDeleteString")        (char p_container[], word w_position);
 int IsEmpty             $asm("TagIsEmpty")              (char p_container[]);
 word GetOffset      $asm("TagGetOffset")             (char p_container[], word w_position);
 word GetSize          $asm("TagGetSize")                (char p_container[]);
 word GetUsed         $asm("TagGetUsed")              (char p_container[]);
//------------------------------------------------
 void MsgContainer(byte p_container[])
    {
    char sz_msg[4];
    word w_index;
    word w_container_size;
    w_container_size = GetSize(p_container);
    for(w_index = 1; w_index <= w_container_size; w_index++)
        {
        Str_Printf(sz_msg, "%02x ", p_container[w_index - 1]);
        Msg_WriteText(sz_msg);
        if(!(w_index % 10))
            Msg_WriteText("\r");
        }
    Msg_WriteText("\r");
    }
//------------------------------------------------
 void MsgInfo(byte p_container[])
    {
    char sz_msg[30];
    Str_Printf(sz_msg, "container begin: %u\r", p_container);
    Msg_WriteText(sz_msg);
    Str_Printf(sz_msg, "container end: %u\r", (p_container[1] << 8) + p_container[0]);
    Msg_WriteText(sz_msg);
    Str_Printf(sz_msg, "container pos: %u\r", (p_container[3] << 8) + p_container[2]);
    Msg_WriteText(sz_msg);
    Str_Printf(sz_msg, "container size: %u\r", GetSize(p_container));
    Msg_WriteText(sz_msg);
    }
//------------------------------------------------
 void MsgAllStrings(char p_container[])
    {
    word w_index;
    word w_used;
    w_used = GetUsed(p_container);
    for(w_index = 5; w_index < w_used; w_index++)
        Msg_WriteChar(p_container[w_index]);
    }
//------------------------------------------------
 void MsgString(char p_container[], word w_number)
    {
    Msg_WriteText(p_container + GetOffset(p_container, w_number));
    }
//------------------------------------------------
 void LCDString(char p_container[], word w_number)
    {
    LCD_ClearLCD();
    LCD_CursorPos(0);
    LCD_WriteText(p_container + GetOffset(p_container, w_number));
    }
//------------------------------------------------