/*** Test2.cc ***/
//------------------------------------------------
// Every test in this program should be activating
// a watchdog reset.
// This program requires these other modules and libraries:
// 1. Regiser.def
// 2. WatchDog.asm
// 3. WatchDog.cc
/*** Please add the required files to your project! ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//------------------------------------------------
 #define PORT_HIGH      1
 #define PORT_LOW       0
 #define EEPROM_ADDRESS 0
//------------------------------------------------
// Comment-out the definitions if no LCD or IDE connected.
 #define OUTPUT_IDE 1
 #define OUTPUT_LCD 1
//------------------------------------------------
 void Output(char p_string[], word w_value)
    {
// output IDE
 #if OUTPUT_IDE
    Msg_WriteText(p_string);
    Msg_WriteWord(w_value);
    Msg_WriteChar(13);
 #endif

// output LCD
 #if OUTPUT_LCD
    LCD_CursorPos(0x00);
    Thread_Delay(1);
    LCD_WriteText(p_string);
    Thread_Delay(1);
    LCD_CursorPos(0x40);
    Thread_Delay(1);
    LCD_WriteWord(w_value, 5);
    Thread_Delay(100);
 #endif

    }
//------------------------------------------------
 void main(void)
    {
    byte by_test_number;

    WatchDogFlagPulse();

 #if OUTPUT_LCD
    LCD_Init();
 #endif

 #if MEGA128_ARCH
    if(WatchDogIsReset())
        {
        Output("WDTReset", GetMCUCSR());
        WatchDogClear();
        }
     else
        {
        Output(" Normal ", GetMCUCSR());
        }
 #else
    Output("MCUCSR: ", GetMCUCSR());
 #endif

    Port_WriteBit(PORT_LED2,   PORT_LOW);
    Port_DataDirBit(PORT_LED2, PORT_OUT);
    by_test_number = EEPROM_Read(EEPROM_ADDRESS);
    switch(by_test_number)
        {
        case 0x00:
            EEPROM_Write(EEPROM_ADDRESS, 0x01);
            Output("test0 ms", 15);
 #if MEGA32 || MEGA128
            WatchDogTest(WDT_12_MS, PS_8, 27648);
 #elif MEGA128CAN
            WatchDogTest(WDT_12_MS, PS_8, 30000);      // 15 ms
 #endif
            break;

        case 0x01:
            EEPROM_Write(EEPROM_ADDRESS, 0x02);
            Output("test1 ms", 30);
 #if MEGA32 || MEGA128
            WatchDogTest(WDT_24_MS, PS_8, 55296);
 #elif MEGA128CAN
            WatchDogTest(WDT_24_MS, PS_8, 60000);      // 30 ms
 #endif
            break;

        case 0x02:
            EEPROM_Write(EEPROM_ADDRESS, 0x03);
            Output("test2 ms", 60);
 #if MEGA32 || MEGA128
            WatchDogTest(WDT_48_MS, PS_64, 13824);
 #elif MEGA128CAN
            WatchDogTest(WDT_48_MS, PS_64, 15000);     // 60 ms
 #endif
            break;

        case 0x03:
            EEPROM_Write(EEPROM_ADDRESS, 0x04);
            Output("test3 ms", 120);
 #if MEGA32 || MEGA128
            WatchDogTest(WDT_96_MS, PS_64, 27648);
 #elif MEGA128CAN
            WatchDogTest(WDT_96_MS, PS_64, 30000);     // 120 ms
 #endif
            break;

        case 0x04:
            EEPROM_Write(EEPROM_ADDRESS, 0x05);
            Output("test4 ms", 240);
 #if MEGA32 || MEGA128
            WatchDogTest(WDT_192_MS, PS_64, 55296);
 #elif MEGA128CAN
            WatchDogTest(WDT_192_MS, PS_64, 60000);    // 240 ms
 #endif
            break;

        case 0x05:
            EEPROM_Write(EEPROM_ADDRESS, 0x06);
            Output("test5 ms", 480);
 #if MEGA32 || MEGA128
            WatchDogTest(WDT_384_MS, PS_256, 27648);
 #elif MEGA128CAN
            WatchDogTest(WDT_384_MS, PS_256, 30000);   // 480 ms
 #endif
            break;

        case 0x06:
            EEPROM_Write(EEPROM_ADDRESS, 0x07);
            Output("test6 ms", 960);
 #if MEGA32 || MEGA128
            WatchDogTest(WDT_768_MS, PS_256, 55296);
 #elif MEGA128CAN
            WatchDogTest(WDT_768_MS, PS_256, 60000);   // 960 ms
 #endif
            break;

        case 0x07:
            EEPROM_Write(EEPROM_ADDRESS, 0x08);
            Output("test7 ms", 1920);
 #if MEGA32 || MEGA128
            WatchDogTest(WDT_1536_MS, PS_1024, 27648);
 #elif MEGA128CAN
            WatchDogTest(WDT_1536_MS, PS_1024, 30000); // 1920 ms
 #endif
            break;

        default:
            Output("tests OK", EEPROM_Read(EEPROM_ADDRESS));
            EEPROM_Write(EEPROM_ADDRESS, 0x00);
 #if MEGA128_ARCH
            if(WatchDogIsReset())
                WatchDogClear();
 #endif
            return;
        }
// The program should never reach this section.
    Port_WriteBit(PORT_LED1, PORT_HIGH);
    Output("ERR by t", by_test_number);
    EEPROM_Write(EEPROM_ADDRESS, 0x00);
    }
//------------------------------------------------