/*** ThreadKeyboard.cc ***/
//------------------------------------------------
// key   #  = select value to set
// key   *  = execute command
// keys 0-8 = values to set
//------------------------------------------------
 #include "main.h"
 #include "RelayCard.h"
//------------------------------------------------
 void SetFrame(byte by_data)
    {
    switch(gby_item)
        {
        case COMMAND:
            gaby_tx_buffer[COMMAND] = by_data;
            break;

        case ADDRESS:
            gaby_tx_buffer[ADDRESS] = by_data;
            break;

        case DATA:
            gaby_tx_buffer[DATA]    = (1 << --by_data);
            break;
        }

    gaby_tx_buffer[CHECKSUM] =
        gaby_tx_buffer[COMMAND] ^
        gaby_tx_buffer[ADDRESS] ^
        gaby_tx_buffer[DATA];

    }
//------------------------------------------------
 void ThreadKeyboard(void)
    {
    word w_key;
    word w_key_old;
    int i_bit_position;

    Port_DataDirBit(PORT_LED1, PORT_OUT);
    w_key     = 0;
    w_key_old = 0;
    while(1)
        {
        w_key = Key_Scan();
        if(w_key)
            {
            Port_WriteBit(PORT_LED1, LED_ON);

            if(w_key == w_key_old)
                continue;
            i_bit_position = 0;
            while(w_key >> ++i_bit_position);

            switch(i_bit_position)
                {
                case KEY_1_POS:
                    SetFrame(1);
                    break;
                case KEY_2_POS:
                    SetFrame(2);
                    break;
                case KEY_3_POS:
                    SetFrame(3);
                    break;
                case KEY_4_POS:
                    SetFrame(4);
                    break;
                case KEY_5_POS:
                   SetFrame(5);
                    break;
                case KEY_6_POS:
                    SetFrame(6);
                    break;
                case KEY_7_POS:
                    SetFrame(7);
                    break;
                case KEY_8_POS:
                    SetFrame(8);
                    break;
                case KEY_9_POS:
                    SetFrame(9);
                    break;
                case KEY_0_POS:
                    SetFrame(0);
                    break;
                case KEY_X_POS:
                    gbo_send = true;
                    break;
                case KEY_H_POS:
                    gby_item = ++gby_item % 3;
                    break;
                }
            w_key_old = w_key;
            }
        else
            Port_WriteBit(PORT_LED1, LED_OFF);

        Thread_Delay(5);
        }
    }
//------------------------------------------------