/*** RelayCardBitSequence.cc ***/
//------------------------------------------------
 #include "RelayCard.h"
//------------------------------------------------
 void RelayCardBitSequenceInit(word w_baudrate)
    {
    byte by_index;

    BitSequenceInit();
    StartTimer1(w_baudrate);
    RelayCardBitSequenceClearBuffer();

    gaby_tx_buffer[COMMAND]  = SETUP;
    gaby_tx_buffer[ADDRESS]  = CARD_1;
    gaby_tx_buffer[DATA]     = 0x00;
    gaby_tx_buffer[CHECKSUM] = SETUP ^ CARD_1 ^ 0x00;

    BitSequenceSend(
        gaby_tx_buffer, FRAME_SIZE,
        gaby_rx_buffer, FRAME_SIZE * (RELAY_CARDS_COUNT + 1),
        TIME_OUT
        );
    Thread_Delay(RELAY_CARDS_COUNT);

    }
//------------------------------------------------
 void RelayCardBitSequenceClearBuffer(void)
    {

    gaby_tx_buffer[COMMAND]  = 0x00;
    gaby_tx_buffer[ADDRESS]  = 0x00;
    gaby_tx_buffer[DATA]     = 0x00;
    gaby_tx_buffer[CHECKSUM] = 0x00;

    BitSequenceSend(
        gaby_tx_buffer, FRAME_SIZE,
        gaby_rx_buffer, FRAME_SIZE,
        TIME_OUT
        );
    Thread_Delay(RELAY_CARDS_COUNT);

    }
//------------------------------------------------
 void RelayCardBitSequenceShowBuffer(byte p_buffer[], word w_buffer_size)
    {
    char ac_msg[10];
    word w_count;

    for(w_count = 0; w_count < w_buffer_size; w_count++)
        {
        if(!(w_count % 4))
            Msg_WriteChar(13);
        Str_Printf(ac_msg, "0x%02x ", p_buffer[w_count]);
        Msg_WriteText(ac_msg);
        }
    Msg_WriteChar(13);
    }
//------------------------------------------------
 void RelayCardBitSequenceShowFrames(word w_tx_buffer_size, word w_rx_buffer_size)
    {

    Msg_WriteText("Send:");
    RelayCardBitSequenceShowBuffer(gaby_tx_buffer, w_tx_buffer_size);
    Msg_WriteText("Receive:");
    RelayCardBitSequenceShowBuffer(gaby_rx_buffer, w_rx_buffer_size);

    }
//------------------------------------------------
 BOOL RelayCardBitSequenceCheckResponse(byte by_received_frames)
    {
    byte by_frame_number;
    byte by_offset;

    for(by_frame_number = 0; by_frame_number < by_received_frames; by_frame_number++)
        {
        by_offset = 4 * by_frame_number;
        if(!(gaby_rx_buffer[CHECKSUM + by_offset] ==
            (gaby_rx_buffer[COMMAND  + by_offset] ^
             gaby_rx_buffer[ADDRESS  + by_offset] ^
             gaby_rx_buffer[DATA     + by_offset])))
                {
                gbo_result = false;
                return false;
                }

        switch(gaby_tx_buffer[COMMAND])
            {
            case NO_OPERATION:
                if( (NO_OPERATION_OK == gaby_rx_buffer[by_offset])
                    ||
                    (NO_OPERATION    == gaby_rx_buffer[by_offset]))
                    break;
                gbo_result = false;
                return false;

            case SETUP:
                if( (SETUP_OK        == gaby_rx_buffer[by_offset])
                    ||
                    (SETUP           == gaby_rx_buffer[by_offset]))
                    break;
                gbo_result = false;
                return false;

            case GET_PORT:
                if( (GET_PORT_OK     == gaby_rx_buffer[by_offset])
                    ||
                    (GET_PORT        == gaby_rx_buffer[by_offset]))
                    break;
                gbo_result = false;
                return false;

            case SET_PORT:
                if( (SET_PORT_OK     == gaby_rx_buffer[by_offset])
                    ||
                    (SET_PORT        == gaby_rx_buffer[by_offset]))
                    break;
                gbo_result = false;
                return false;

            case GET_OPTION:
                if( (GET_OPTION_OK   == gaby_rx_buffer[by_offset])
                    ||
                    (GET_OPTION      == gaby_rx_buffer[by_offset]))
                    break;
                gbo_result = false;
                return false;

            case SET_OPTION:
                if( (SET_OPTION_OK   == gaby_rx_buffer[by_offset])
                    ||
                    (SET_OPTION      == gaby_rx_buffer[by_offset]))
                    break;
                gbo_result = false;
                return false;

            case SET_SINGLE:
                if( (SET_SINGLE_OK   == gaby_rx_buffer[by_offset])
                    ||
                    (SET_SINGLE      == gaby_rx_buffer[by_offset]))
                    break;
                gbo_result = false;
                return false;

            case DEL_SINGLE:
                if( (DEL_SINGLE_OK   == gaby_rx_buffer[by_offset])
                    ||
                    (DEL_SINGLE      == gaby_rx_buffer[by_offset]))
                    break;
                gbo_result = false;
                return false;

            case TOGGLE:
                if( (TOGGLE_OK       == gaby_rx_buffer[by_offset])
                    ||
                    (TOGGLE          == gaby_rx_buffer[by_offset]))
                    break;
                gbo_result = false;
                return false;

            default:
                gbo_result = false;
                return false;
            }
        }

    gbo_result = true;
    return true;
    }
//------------------------------------------------
