/*** DemoBitSequence.cc ***/
//------------------------------------------------
// This program controls the 8 x conrad relay cards (Nr. 19 77 30)
// via two IO-Ports and Timer1.
// Mega32     RX = PINC2, TX = PORTC3
// Mega128    RX = PINE2, TX = PORTE3
// Mega128Can RX = PINE2, TX = PORTE3
// Because the microcontroller ports use a logic level based
// on a 5V power supply, the ports must be connected with the
// 1st relay card via a interface chip! MAX232 for example.
// The correct number of the relay cards must be defined
// in the headerfile "RelayCard.h".
/*** Keyboard ***/
// key   #  = select value to set
// key   *  = execute command
// keys 0-8 = values to set
/*** LCD-Display ***/
// |--------|
// |C???A???|
// |00100000|
// |--------|
// 1st line C = Commando, A = Address
// 2nd line = Data
//------------------------------------------------
// This program requires these other modules and libraries:
// 1. main.h
// 2. RelayCard.h
// 3. BitSequence.h
// 4. RelayCardBitSequence.cc
// 5. BitSequence.asm
// 6. BitSequence.cc
// 7. ThreadDisplay.cc
// 8. ThreadKeyboard.cc
/*** Please add the required files to your project! ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//-----------------------------------------------
 #include "main.h"
 #include "RelayCard.h"
//------------------------------------------------
 byte gaby_tx_buffer[FRAME_SIZE] = {0, 0, 0, 0};
 byte gaby_rx_buffer[FRAME_SIZE * (RELAY_CARDS_COUNT + 1)] = {0, 0, 0, 0};
 byte gby_item;
 BOOL gbo_result;
 BOOL gbo_send;
//------------------------------------------------
 void main(void)
    {
    byte by_expected_frames;

    gby_item   = 0;
    gbo_result = false;
    gbo_send   = false;

    LCD_Init();
    LCD_CursorOn();
    LCD_CursorPos(0x00);
    Thread_Delay(1);
    LCD_WriteText("-Set Up-");
    LCD_CursorPos(0x40);
    Thread_Delay(1);
    RelayCardBitSequenceInit(BAUDRATE_19200);
 #ifdef DEBUG
    RelayCardBitSequenceShowFrames(FRAME_SIZE, FRAME_SIZE * (RELAY_CARDS_COUNT + 1));
 #endif
    if(RelayCardBitSequenceCheckResponse(RELAY_CARDS_COUNT + 1))
        {
        LCD_WriteText("---OK---");
 #ifdef DEBUG
        Msg_WriteText("RelayCardBitSequenceInit -> OK\r");
 #endif
        }
    else
        {
        LCD_WriteText("--ERROR-");
 #ifdef DEBUG
        Msg_WriteText("RelayCardBitSequenceInit -> ERROR\r");
 #endif
        }
    Thread_Delay(200);

    Thread_Start(THREAD_KEYBOARD, ThreadKeyboard);
    Thread_Start(THREAD_DISPLAY,  ThreadDisplay);

    while(1)
        {
        if(gbo_send)
            {
            Thread_Lock(1);
            if((BROADCAST_ADDR == gaby_tx_buffer[ADDRESS])
               ||
               (SETUP          == gaby_tx_buffer[COMMAND]))
                    by_expected_frames = RELAY_CARDS_COUNT + 1;
            else
                by_expected_frames = 1;

            BitSequenceSend(
                gaby_tx_buffer, FRAME_SIZE,
                gaby_rx_buffer, FRAME_SIZE * by_expected_frames,
                TIME_OUT
                );
            RelayCardBitSequenceCheckResponse(by_expected_frames);
            gby_item = SHOW_RESULT;

 #ifdef DEBUG
            RelayCardBitSequenceShowFrames(
                 FRAME_SIZE,
                (FRAME_SIZE * by_expected_frames)
                );
            Msg_WriteChar(13);
 #endif
            Thread_Lock(0);
            gbo_send = false;
            }
        Thread_Delay(50);
        }
    }
//------------------------------------------------