/*** BitSequence.h ***/
//------------------------------------------------
 #ifndef __BIT_SEQUENCE__
 #define __BIT_SEQUENCE__
//------------------------------------------------
 #if MEGA32 || MEGA128

// 1 / 14745600 Hz = 6.78e-8 s = 1 cpu tick

// 1 /      225 bit/s / 6.78e-8 s = 65535 = 0xFFFF
 #define BAUDRATE_225    0xFFFF

// 1 /      300 bit/s / 6.78e-8 s = 49152 = 0xC000
 #define BAUDRATE_300    0xC000

// 1 /      600 bit/s / 6.78e-8 s = 24576 = 0x6000
 #define BAUDRATE_600    0x6000

// 1 /     1200 bit/s / 6.78e-8 s = 12288 = 0x3000
 #define BAUDRATE_1200   0x3000

// 1 /     1800 bit/s / 6.78e-8 s = 8192  = 0x2000
 #define BAUDRATE_1800   0x2000

// 1 /     2400 bit/s / 6.78e-8 s = 6144  = 0x1800
 #define BAUDRATE_2400   0x1800

// 1 /     4800 bit/s / 6.78e-8 s = 3072  = 0x0C00
 #define BAUDRATE_4800   0x0BFF

// 1 /     7200 bit/s / 6.78e-8 s = 2048  = 0x0800
 #define BAUDRATE_7200   0x07FF

// 1 /     9600 bit/s / 6.78e-8 s = 1556  = 0x0600
 #define BAUDRATE_9600   0x0600

// 1 /    14400 bit/s / 6.78e-8 s = 1024  = 0x0400
 #define BAUDRATE_14400  0x0400

// 1 /    19200 bit/s / 6.78e-8 s = 768   = 0x0300
 #define BAUDRATE_19200  0x02FF

// 1 /    28800 bit/s / 6.78e-8 s = 512   = 0x0200
 #define BAUDRATE_28800  0x01FF

// 1 /    38400 bit/s / 6.78e-8 s = 384   = 0x0180
 #define BAUDRATE_38400  0x0180

// 1 /    57600 bit/s / 6.78e-8 s = 256   = 0x0100
 #define BAUDRATE_57600  0x0100

// 1 /    76800 bit/s / 6.78e-8 s = 192   = 0x00C0
 #define BAUDRATE_76800  0x00C0

// 1 /   115200 bit/s / 6.78e-8 s = 128   = 0x0080
 #define BAUDRATE_115200 0x0080

// 1 /   230400 bit/s / 6.78e-8 s = 64    = 0x0040
 #define BAUDRATE_230400 0x0040

// 1 /   460800 bit/s / 6.78e-8 s = 32    = 0x0020
 #define BAUDRATE_460800 0x001F

// 1 /   921600 bit/s / 6.78e-8 s = 16    = 0x0010
 #define BAUDRATE_921600 0x000F

 #elif MEGA128CAN

// 1 / 16000000 Hz =  6,25e-8 s = 1 cpu tick

// 1 /      244 bit/s / 6.25e-8 s = 65535 = 0xFFFF
 #define BAUDRATE_244    0xFFFF

// 1 /      300 bit/s / 6.25e-8 s = 53333 = 0xD055
// #define BAUDRATE_300  0xD054 // it does not work???

// 1 /      600 bit/s / 6.25e-8 s = 26666 = 0x682A
 #define BAUDRATE_600    0x682A

// 1 /     1200 bit/s / 6.25e-8 s = 13333 = 0x3415
 #define BAUDRATE_1200   0x3415

// 1 /     1800 bit/s / 6.25e-8 s = 8888  = 0x22B8
 #define BAUDRATE_1800   0x22B8

// 1 /     2400 bit/s / 6.25e-8 s = 6666  = 0x1A0A
 #define BAUDRATE_2400   0x1A0A

// 1 /     4800 bit/s / 6.25e-8 s = 3333  = 0x0D05
 #define BAUDRATE_4800   0x0D05

// 1 /     7200 bit/s / 6.25e-8 s = 2222  = 0x08AE
 #define BAUDRATE_7200   0x08AE

// 1 /     9600 bit/s / 6.25e-8 s = 1666  = 0x0682
 #define BAUDRATE_9600   0x0682

// 1 /    14400 bit/s / 6.25e-8 s = 1111  = 0x0457
 #define BAUDRATE_14400  0x0456

// 1 /    19200 bit/s / 6.25e-8 s = 833   = 0x0341
 #define BAUDRATE_19200  0x0340

// 1 /    28800 bit/s / 6.25e-8 s = 555   = 0x022B
 #define BAUDRATE_28800  0x022B

// 1 /    38400 bit/s / 6.25e-8 s = 416   = 0x01A0
 #define BAUDRATE_38400  0x01A0

// 1 /    57600 bit/s / 6.25e-8 s = 277   = 0x0115
 #define BAUDRATE_57600  0x0115

// 1 /    76800 bit/s / 6.25e-8 s = 208   = 0x00D0
 #define BAUDRATE_76800  0x00D0

// 1 /   115200 bit/s / 6.25e-8 s = 138   = 0x008A
 #define BAUDRATE_115200 0x008A

// 1 /   230400 bit/s / 6.25e-8 s = 69    = 0x0045
 #define BAUDRATE_230400 0x0045

// 1 /   460800 bit/s / 6.25e-8 s = 34    = 0x0022
 #define BAUDRATE_460800 0x0022

// 1/    921600 bit/s / 6.25e-8 s = 17    = 0x0011
 #define BAUDRATE_921600 0x0011

 #endif
//------------------------------------------------
 #endif
//------------------------------------------------