/*******************************************************************************
 Projektname:       LED-Lauflicht.cprj                                      V1.3
 Bentigte Libss:  IntFunc_lib.cc
 Routinen:
 Autor:             SC & US (CTC)
 Datum:             12.04.2011

 Funktion:          Es werden 16 LED's in Form eines Lauflichts geschaltet.
                    Zustzlich sind noch 3 weitere Ausgnge vorhanden.
                    Die Lauflichtprogramme knnen durch einen Taster auf der
                    Platine oder durch die Pulsbreite in Form einer
                    Servoansteuerung ausgewhlt werden.
                    Das Zeitverhalten des Lauflichts und das Speichern
                    der beiden Parameter Zeitverhalten und Programm erfolgt
                    ebenfalls durch einen Taster auf der Platine.

                    Hardware Test:
                    Nach dem anlegen der Versorgungsspannung an der Platine,
                    leuchtet kurz darauf die LED1. Nun mssen Sie den Taster SW2
                    lnger als 3 Sekunden drcken. Die LEDs schalten sich nun
                    nacheinader ein. Leuchten alle LEDs so ist die Platine okay.
                    Nach einer kurzen Verweilzeit schalten die LEDs aus und das
                    eingespeicherte Programm beginnt.


                    Programmanwahl:
                        Durch kurzes drcken der Taste S2 wird das nchste
                        Programm angewhlt.

                    Zeitverhalten:
                        Die Taste S2 solange Drcken bis die Status LED
                        aufleuchtet. Danach die Taste wieder los lassen. Zum
                        verndern des Zeitverhalten die Taste S2 wieder kurz
                        Drcken. Der timemode wird wieder verlassen, in dem die
                        Taste S2 wieder solange gedrckt wird bis die Status
                        LED wieder erlischt.

                    Speichern des Zeitverhalten und Programms.
                        Die Taste S2 solange gedrckt halten bis die Status LED
                        aufleuchtet, erlischt und schlielich schnell blinkt.

                    Status LED:
                        LED aus:    Taster S2 schaltet das Programm weiter.
                        LED ein:    Taster S2 verndert die Lauflichtzeit
                        LED blinkt: Zeitverhalten und Programm werden gespeichert.

                    Servoansteuerung(RC):
                        Sind whrend der Hochlaufphase gltige Servosignale
                        vorhanden, wird die Platine in den RC-Mode geschaltet.
                        Zwischen den Ausgaben der LED's wird die Pulsbreite der
                        Servosignale erfasst und verarbeitet.
                        Die Servoansteuerung verndert das aktuelle Lauflicht-
                        programm und schaltet die 3 zustzlichen Ausgnge

                        Pulsbreite 1.8ms:
                            LED-Lauflicht Programm wird weiter geschaltet

                        Pulsbreite 1,5ms:
                            Es hat keine Zustandsnderung zur Folge

                        Pulsbreite 1.2ms:
                            Die 3 zustzlichen Ausgnge werden bei jedem Wechsel
                            der Pulsbreite von 1,5ms auf 1ms nacheinander
                            eingeschaltet und wieder ausgeschaltet.


                        Info: Wird der RC-Eingang nicht benutzt, so muss ein
                        Jumper RM2,54 auf den Pin gegen Masse gesteckt werden!
                        Wird dies nicht gemacht, sind die Zeiten zwischen
                        RC-Mode und Stand-alone unterschiedlich!

                    ************************************************************
                    There are 16 led switched in form of moving light.
                    Additional there are 3 outputs.
                    The Programms of the moving light are selectable through the
                    button S2 on the PCB or through the width of a puls of a
                    servo control.
                    The timing of the moving light and the storage of the timing
                    and the active programm is a further function of the
                    button S2.

                    programm selection:
                        short pushing the button S2 selects the next
                        moving light programm

                    timing selection:
                        Press the button until the status LED goes on.
                        Further short pushing the button S2 changes the time
                        to the next time base.
                        The timemode will be left, when you press the button
                        until the status LED goes off.

                    storage of the timing and activ programm
                        Press the button until the status LED goes on, goes off
                        and in the end is flashing.

                    servo control (RC)
                        Are there servo signals at the beginning, the PCB
                        is switched in to the RC-Mode.
                        The servo control can change the moving light programm
                        and can switch on and off 3 additional outputs.

                        pulse width 2ms:
                            change the moving light programm

                        pulse width 1,5ms:
                            There is no change

                        pulse width 1ms:
                            The 3 additional outputs will be switched on and off
                            after every change from 1,5ms width to 1ms width.


                        Info note: not used the RC-input, then an
                        Jumper RM2,54 are plugged into the pin to ground!
                        If this is not done, the time between
                        RC mode and stand alone-different!

********************************************************************************
changes for the adding a moving light programm:
    1. #define  PROGANZAHL      8           // number of LED programms
    2. main:    // moving light programm 8
                case 8:
                LEDProgramm_8();
                break;
    3. moving light programm




*******************************************************************************/
/*------------------------------------------------------------------------------
//defines
------------------------------------------------------------------------------*/
#define PROGANZAHL      18  // number of LED programms
#define TIMELEDMAX      52  // ((52/2)-1)*(15*5)ms max time for moving light
#define TIMELEDMIN      1   // 1*15ms min time for moving light
#define CNTTIME         200 // min time (200 * 10ms) for button S2 to go in timemode
#define CNTSTORE        400 // min time (400 * 10ms) for button S2 to store
#define EEPROMADRTIME   0   // address in the EEProm for time
#define EEPROMADRPROG   2   // address in the EEProm for programm

#define PORT_S2         26  // portnumber of button S2
#define STATUSLED       31  // portnumber of the Status LED


/*------------------------------------------------------------------------------
// globale Variablen Definition
------------------------------------------------------------------------------*/
byte programm,programm_k1,programm_save,lockprog,lockS2,timemode,outputupdate;
byte auxoutput,position,RCmode,RCmodeStart;
word outputs;
word PM_wert,timeled,timeled_k1,timeticks;
word automode,autocnt,autostep,x,programmfinished;


/*------------------------------------------------------------------------------
// main programm
------------------------------------------------------------------------------*/
void main(void)
{

    // init of the port for input and output
    LED_Init();


    // systemcheck sush S2 on power On more the 1Sec.
    if(Port_ReadBit(PORT_S2)==0)
    {
        AbsDelay(1000);
        if(Port_ReadBit(PORT_S2)==0);
        {
            // all leds one after another on and finally off
            SystemCheck();
        }
    }


    // Interrupt Service Routine for  servo signals
    Irq_SetVect(INT_TIM1CAPT,Timer1_ISR);

    // fr ISR LED-Ausgabe
    Irq_SetVect(INT_TIM0COMP,LED_Output_ISR);

    // every 5ms the isr to update the outputs - US
    Timer_T0Time(72,PS0_1024);


    // check the connecting of servo signals (RC)
    CheckRCmode();

    // Memory setup
    if((programm_save!=1)&&(RCmode==1))programm_save=programm_save-1;



    while(1)
    {
        // saving the settings of the programmcycle befor
        programm_k1=programm;
        timeled_k1=timeled;

        if(outputupdate==0)
        {
            switch (programm)
            {
                // moving light programm 1 (LEDs OFF)
                case 1:
                automode=0;
                LEDProgramm_1();
                break;

                // moving light programm 2
                case 2:
                LEDProgramm_2();
                break;

                // moving light programm 3
                case 3:
                LEDProgramm_3();
                break;

                // moving light programm 4
                case 4:
                LEDProgramm_4();
                break;

                // moving light programm 5
                case 5:
                LEDProgramm_5();
                break;

                // moving light programm 6
                case 6:
                LEDProgramm_6();
                break;

                // moving light programm 7
                case 7:
                LEDProgramm_7();
                break;

                // moving light programm 8
                case 8:
                LEDProgramm_8();
                break;

                // moving light programm 9
                case 9:
                LEDProgramm_9();
                break;

                // moving light programm 10
                case 10:
                LEDProgramm_10();
                break;

                // moving light programm 11
                case 11:
                LEDProgramm_11();
                break;

                // moving light programm 12
                case 12:
                LEDProgramm_12();
                break;

                // moving light programm 13
                case 13:
                LEDProgramm_13();
                break;

                // moving light programm 14
                case 14:
                LEDProgramm_14();
                break;

                // moving light programm 15
                case 15:
                LEDProgramm_15();
                break;

                // moving light programm 16
                case 16:
                LEDProgramm_16();
                break;

                // moving light programm 17
                case 17:
                LEDProgramm_17();
                break;

                // moving light programm auto 2 to 17
                case 18:

                   // automode start
                   if(automode==0)
                   {
                      automode=1;
                      autostep=1;
                      Port_Write(0,0);
                      Port_Write(2,0);
                      AbsDelay(100);

                      // automode indicator
                      for(x=0;x<10;x++)
                      {
                          Port_Write(0,255);
                          Port_Write(2,255);
                          AbsDelay(50);
                          Port_Write(0,0);
                          Port_Write(2,0);
                          AbsDelay(50);
                      }
                   }

                   if((autocnt>1024)&&(programmfinished==0))
                   {
                       autocnt=0;
                       autostep++;
                       outputs=0x0000;
                   }

                   if(autostep>=17)autostep=1;

                   programmfinished=1;

                   // automode programm counter
                   switch (autostep)
                   {

                          case 1:
                          LEDProgramm_2();
                          break;

                          case 2:
                          LEDProgramm_3();
                          break;

                          case 3:
                          LEDProgramm_4();
                          break;

                          case 4:
                          LEDProgramm_5();
                          break;

                          case 5:
                          LEDProgramm_6();
                          break;

                          case 6:
                          LEDProgramm_7();
                          break;

                          case 7:
                          LEDProgramm_8();
                          break;

                          case 8:
                          LEDProgramm_9();
                          break;

                          case 9:
                          LEDProgramm_10();
                          break;

                          case 10:
                          LEDProgramm_11();
                          break;

                          case 11:
                          LEDProgramm_12();
                          break;

                          case 12:
                          LEDProgramm_13();
                          break;

                          case 13:
                          LEDProgramm_14();
                          break;

                          case 14:
                          LEDProgramm_15();
                          break;

                          case 15:
                          LEDProgramm_16();
                          break;

                          case 16:
                          LEDProgramm_17();
                          break;

                   }
                   break;


                // next moving light programm

                default:
                timeled=TIMELEDMIN;
                programm=1;
                automode=0;
                break;
            }

            // lock the outputs update
            outputupdate=1;
        }


        // check the function of S2 about change to timemode or
        // store the time and programm
        FunctionS2();

        // check programm change with RC
        if(RCmode)RCprogchange();


    }
}

/*------------------------------------------------------------------------------
name:           LED_Init
input:          none
output:         none
description:    init of the ports , timing, first programm and the interrupts
------------------------------------------------------------------------------*/
void LED_Init (void)
{
    auxoutput=1;
    lockprog=0;
    lockS2=0;
    timemode=0;
    timeled=0;
    timeled_k1=0;
    programm=1;
    programm_k1=1;
    timeticks=0;
    outputupdate=0;
    position=1;
    programm_save=1;
    RCmodeStart=255;
    automode=0;
    autocnt=0;
    autostep=0;
    programmfinished=0;
    x=0;


    // button S2 as input
    Port_DataDirBit(PORT_S2,0);

    // switch on pull up
    Port_WriteBit(PORT_S2,1);

    // Statusled
    Port_DataDirBit(STATUSLED,1);
    Port_WriteBit(STATUSLED,0);

    // Port A  as output
    Port_DataDir(0,255);
    Port_Write(0,0);

    // Port C  as output
    Port_DataDir(2,255);
    Port_Write(2,0);

    // PB0 - PB3 as output
    Port_DataDirBit(8,1);
    Port_WriteBit(8,0);
    Port_DataDirBit(9,1);
    Port_WriteBit(9,0);
    Port_DataDirBit(10,1);
    Port_WriteBit(10,0);
    Port_DataDirBit(11,1);
    Port_WriteBit(11,0);


    // values for time and programm from the EEProm
    timeled=EEPROM_ReadWord(EEPROMADRTIME);
    programm_save=EEPROM_Read(EEPROMADRPROG);


    if(timeled>=TIMELEDMAX || timeled<=TIMELEDMIN)
       timeled=TIMELEDMIN;


    // Ready for SystemCheck
    Port_WriteBit(STATUSLED,1);
    AbsDelay(1000);
    Port_WriteBit(STATUSLED,0);

}

/*------------------------------------------------------------------------------
name:           SystemCheck
input:          none
output:         none
description:    this routine turn on all outputs for 3 sec. and finaly turn off
------------------------------------------------------------------------------*/
void SystemCheck(void)
{

    int ii,val,cntcheck;

    outputs=0;
    for(cntcheck=0;cntcheck<17;cntcheck++)
    {
        outputs=outputs + kit[cntcheck];

        val= outputs & 0x00FF;
        Port_Write(0,val);

        for(ii=0;ii<8;ii++)
        {
            val=(outputs >> 8 + ii) & 0x0001;
            Port_WriteBit(23 - ii,val);
            val=0;
        }

        AbsDelay(250);
    }


    // PB0 - PB3 on
    Port_WriteBit(8,1);
    AbsDelay(250);
    Port_WriteBit(9,1);
    AbsDelay(250);
    Port_WriteBit(10,1);
    AbsDelay(250);
    Port_WriteBit(11,1);

    AbsDelay(3000);

    // status led off
    Port_WriteBit(STATUSLED,0);

    // Port A  off
    Port_Write(0,0);

    // Port C off
    Port_Write(2,0);

    //PB0 - PB3 off
    Port_WriteBit(8,0);
    Port_WriteBit(9,0);
    Port_WriteBit(10,0);
    Port_WriteBit(11,0);

    AbsDelay(500);

}

/*------------------------------------------------------------------------------
name:           CheckRCmode
input:          values of the outputs
output:         none
description:    this routine check the connecting with RC signals
------------------------------------------------------------------------------*/
void CheckRCmode(void)
{
    int RCpuls;

    RCpuls=0;
    // reading in the pulse width of RC
    RCpuls=ReadPM();

    if(RCpuls >= 0x0142 && RCpuls < 0x0170)
    {
        RCmode=1;
        RCmodeStart=0;
    }
    else
    {
        RCmode=0;
        programm=programm_save; // start saved LED programm
    }
}

/*------------------------------------------------------------------------------
name:           LED_Output_ISR
input:          none
output:         none
description:    this routine switch on and off the outputs
------------------------------------------------------------------------------*/
void LED_Output_ISR (void)
{
    int ii,val;
    Timer_T0Stop();

    if(timeticks >= timeled)
    {

        // special function powerports
        switch(auxoutput)
        {
                case 1:
                Port_WriteBit(8,0);
                Port_WriteBit(9,0);
                Port_WriteBit(10,0);
                Port_WriteBit(11,0);
                break;

                case 2:
                Port_WriteBit(8,1);
                Port_WriteBit(9,0);
                Port_WriteBit(10,0);
                Port_WriteBit(11,0);
                break;

                case 3:
                Port_WriteBit(8,1);
                Port_WriteBit(9,1);
                Port_WriteBit(10,0);
                Port_WriteBit(11,0);
                break;

                case 4:
                Port_WriteBit(8,1);
                Port_WriteBit(9,1);
                Port_WriteBit(10,1);
                Port_WriteBit(11,0);
                break;

                case 5:
                Port_WriteBit(8,1);
                Port_WriteBit(9,1);
                Port_WriteBit(10,1);
                Port_WriteBit(11,1);
                break;

        }


        // port A
        val= outputs & 0x00FF;
        Port_Write(0,val);


        for(ii=0;ii<8;ii++)
        {
            val=(outputs >> 8 + ii) & 0x0001;
            Port_WriteBit(23 - ii,val);
            val=0;
        }


        // reset the timeticks
        timeticks=1;
        outputupdate=0;
    }
    else
    {
       timeticks++;
       autocnt++;  // automode
    }

    Timer_T0Time(72,PS0_1024);   // US
    Irq_GetCount(INT_TIM0COMP);
}

/*------------------------------------------------------------------------------
name:           Timer1_ISR
input:          none
output:         none
description:    this interrupt service routine reads out the puls width of
                the servo signals
------------------------------------------------------------------------------*/
void Timer1_ISR(void)
{
    int irqcnt;

    // reading out pulse width
    PM_wert=Timer_T1GetPM();
    irqcnt=Irq_GetCount(INT_TIM1CAPT);
}

/*------------------------------------------------------------------------------
name:           ReadPM
input:          none
output:         value of pulse width (RC signals)
description:    this routine starts the measure of pulse width
------------------------------------------------------------------------------*/
int ReadPM (void)
{
    int ii,kk;
    kk=0;

    // the measure starts here
    // impulssignal connecting with port ICP(input capture pin, PortD.6)
    PM_wert=0;

    // 0 = pulse width setting, define prescaler
    Timer_T1PM(0,PS_64);

    // measure the pulse width
    while(PM_wert==0)
    {
        //wait
        for(ii=0;ii<10;ii++);
        kk++;
        if(kk==50)
           break;
    }

    return (PM_wert);
}

/*------------------------------------------------------------------------------
name:           RCprogchange
input:          none
output:         none
description:    this routine changes the moving light programm and the
                additional outputs
------------------------------------------------------------------------------*/
void RCprogchange(void)
{
     int RCpuls;
     RCpuls=0;

     if(Port_ReadBit(PORT_S2))
     {
        // reading the RC pulse width
        RCpuls=ReadPM();


        if(RCpuls > 0x0178 && RCpuls < 0x1FA) // > 1700 && < 2200s
        {
            if(!lockprog)
            {
                // first change call the saved programm!
                if(RCmodeStart==0)
                {
                   programm=programm_save; // start saved LED programm
                   RCmodeStart=1;
                }

                // change the moving light programm
                programm=programm +1;
                if(programm>PROGANZAHL)
                {
                   programm=1;
                }

                position=1;
                lockprog=1;
            }

        }
        else if(RCpuls > 0x00B8 && RCpuls <= 0x012B) // > 800 && < 1300s - US
        {
            if(!lockprog)
            {   // change the status of the 3 additional outputs
                lockprog=1;
                auxoutput++;
                if(auxoutput>5) // states
                {
                    auxoutput = 1;
                }
            }
        }
        else
        {
           lockprog=0;
        }

     }

}

/*------------------------------------------------------------------------------
name:           FunctionS2
input:          none
output:         none
description:    checks the button about starting timemode or store the aktiv
                time and programm
------------------------------------------------------------------------------*/
void FunctionS2(void)
{
    int ii;
    word cntS2;

        if(!Port_ReadBit(PORT_S2))
        {
            cntS2=0;
            do
            {   // display the timemode or storage mode  with the status LED by
                // hold the button S2
                AbsDelay(10);
                cntS2++;

                if(cntS2>CNTSTORE)
                {   // storage mode
                    for(ii=0;ii<3;ii++)
                    {   // flashing the status LED
                        AbsDelay(100);
                        Port_ToggleBit(STATUSLED);
                        AbsDelay(100);
                        Port_WriteBit(STATUSLED,0 );
                    }

                }
                else if(cntS2 > CNTTIME && cntS2 < CNTSTORE)
                {   // timemode
                    if(timemode==1)
                        Port_WriteBit(STATUSLED,0);
                    else Port_WriteBit(STATUSLED,1);
                }
            }

            while(!Port_ReadBit(PORT_S2));

            // execute the task programm, time or store
            if(cntS2 > CNTSTORE)
            {
                //storage mode
                EEPROM_WriteWord(EEPROMADRTIME,timeled_k1);
                EEPROM_Write(EEPROMADRPROG,programm_k1);

                programm=programm_k1;
                timeled=timeled_k1;
                timemode=0;
            }
            else if(cntS2 >= CNTTIME && cntS2 <= CNTSTORE)
            {
                // time mode
                if(timemode==1)
                {   timemode=0;
                    Port_WriteBit(STATUSLED,0);
                }
                else
                {   timemode=1;
                    Port_WriteBit(STATUSLED,1);
                }

                programm=programm_k1;
                timeled=timeled_k1;
            }
            else
            {

                if(!lockS2)
                {

                      if(!timemode && !RCmode)
                      {   // change the moving light programm
                          programm=programm+1;
                          if(programm > PROGANZAHL)programm=1;
                      }
                      else if(timemode)
                      {   // change the time base of the moving light - US
                          timeled=timeled+2;
                          if(timeled >= TIMELEDMAX)timeled=TIMELEDMIN;
                      }

                      position=1;
                      timeticks=1;
                      lockS2=1;
                }

            }

        }
        else lockS2=0;

}

/*------------------------------------------------------------------------------
name:           LEDProgramm_1
input:          none
output:         none
description:    LEDs off
------------------------------------------------------------------------------*/
void LEDProgramm_1(void)
{
    outputs=0;
    outputupdate=1;
}

/*------------------------------------------------------------------------------
name:           LEDProgramm_2
input:          none
output:         none
description:    this routine puts together the moving light programm
------------------------------------------------------------------------------*/
void LEDProgramm_2(void)
{
    if(position==1)
    {
       outputs=1;
    }
    else if(position < 17)
    {
       outputs=outputs << 1;
    }
    else
    {
       outputs=outputs >> 1;
       if(position >= 30)
       {
          position=0;
          programmfinished=0;
       }
    }

    position++;
    outputupdate=1;
}

/*------------------------------------------------------------------------------
name:           LEDProgramm_3
input:          none
output:         none
description:    this routine puts together the moving light programm
------------------------------------------------------------------------------*/
void LEDProgramm_3(void)
{
    if(position==1)
    {
       outputs=1;
    }
    else
    {
        outputs=outputs << 1;
        if (position >= 16)
        {
            position=0;
            programmfinished=0;
        }
    }

    position++;
    outputupdate=1;
}

/*------------------------------------------------------------------------------
name:           LEDProgramm_4
input:          none
output:         none
description:    this routine puts together the moving light programm
------------------------------------------------------------------------------*/
void LEDProgramm_4(void)
{
    int tmp;

    if(position==1)
    {
       outputs=0x8001;
    }
    else if(position < 9)
    {
       tmp=(outputs >> 1) & 0xFF00;
       outputs=(outputs << 1) & 0x00FF;
       outputs=outputs | tmp;
    }
    else if((position > 9) && (position < 16))
    {
       tmp=(outputs & 0xFF00) << 1;
       outputs=(outputs & 0x00FF) >> 1;
       outputs=outputs | tmp;
    }
    else if(position >= 16)
    {
            position=0;
            programmfinished=0;
    }

    position++;
    outputupdate=1;
}

/*------------------------------------------------------------------------------
name:           LEDProgramm_5
input:          none
output:         none
description:    this routine puts together the moving light programm
------------------------------------------------------------------------------*/
void LEDProgramm_5(void)
{
    if(position==1)
    {
       outputs=0x0003;
    }
    else if(position < 16)
       outputs=outputs << 1;
    else
    {
       outputs=outputs >> 1;
       if(position >= 28)
       {
          position=0;
          programmfinished=0;
       }
    }

    position++;
    outputupdate=1;
}

/*------------------------------------------------------------------------------
name:           LEDProgramm_6
input:          none
output:         none
description:    this routine puts together the moving light programm
------------------------------------------------------------------------------*/
void LEDProgramm_6(void)
{
    int tmp;

    if(position==1)
    {
       outputs=0x8001;
    }
    else
    {
       tmp= (outputs >> 1) & 0xFF00;
       outputs=(outputs << 1) & 0x00FF;
       outputs=outputs|tmp;
    }

    if(position >= 16)
    {
       position=0;
       programmfinished=0;
    }

    position++;
    outputupdate=1;
}

/*------------------------------------------------------------------------------
name:           LEDProgramm_7
input:          none
output:         none
description:    this routine puts together the moving light programm
------------------------------------------------------------------------------*/
void LEDProgramm_7(void)
{
    if(position==1)
    {
       outputs=0x0101;
    }
    else
    {
        outputs=outputs << 1;
        if(position >= 8)
        {
            position=0;
            programmfinished=0;
        }
    }

    position++;
    outputupdate=1;
}

/*------------------------------------------------------------------------------
name:           LEDProgramm_8
input:          none
output:         none
description:    this routine puts together the moving light programm
------------------------------------------------------------------------------*/
void LEDProgramm_8(void)
{
    if(position==1)
    {
       outputs=0x0001;
    }
    else if(position % 2)
    {
       outputs=outputs >> 1;
    }
    else
    {
        outputs=outputs << 2;
        if (position >= 28)
        {
            position=0;
            programmfinished=0;
        }
    }

    position++;
    outputupdate=1;
}

/*------------------------------------------------------------------------------
name:           LEDProgramm_9
input:          none
output:         none
description:    this routine puts together the moving light programm
------------------------------------------------------------------------------*/
void LEDProgramm_9(void)
{
    if(position==1)
    {
       outputs=0x9249;
    }
    else
    {
        outputs=outputs << 1;
        if (position >= 3)
        {
            position=0;
            programmfinished=0;
        }
    }

    position++;
    outputupdate=1;
}

/*------------------------------------------------------------------------------
name:           LEDProgramm_10
input:          none
output:         none
description:    this routine puts together the moving light programm
------------------------------------------------------------------------------*/
void LEDProgramm_10(void)
{
    if(position==1)
    {
       outputs=0xF000;
    }
    else
    {
        outputs=outputs >> 1;
        if (position >= 16)
        {
            position=0;
            programmfinished=0;
        }
    }

    position++;
    outputupdate=1;
}

/*------------------------------------------------------------------------------
name:           LEDProgramm_11
input:          none
output:         none
description:    this routine puts together the moving light programm
------------------------------------------------------------------------------*/
void LEDProgramm_11(void)
{
    if(position==1)
    {
        outputs=3;
    }
    else if(position < 9)
        outputs=outputs << 2;
    else
    {
        outputs=outputs >> 2;
        if(position >= 14)
        {
           position=0;
           programmfinished=0;
        }
    }

    position++;
    outputupdate=1;
}

/*------------------------------------------------------------------------------
name:           LEDProgramm_12
input:          none
output:         none
description:    this routine puts together the moving light programm
------------------------------------------------------------------------------*/
int kit[17]={0,1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768};
void LEDProgramm_12(void)
{
    if(position==1)
    {
       outputs=0;
    }

    if(position < 17)
    {
        outputs=outputs + kit[position];
    }
    else
    {
        position=0;
        outputs=0;
        programmfinished=0;
    }

    position++;
    outputupdate=1;
}

/*------------------------------------------------------------------------------
name:           LEDProgramm_13
input:          none
output:         none
description:    this routine puts together the moving light programm
------------------------------------------------------------------------------*/
void LEDProgramm_13(void)
{
    switch(position)
    {
        case 1:
        outputs=0xFFFF;
        break;

        case 2:
        outputs=0x0000;
        break;

        case 3:
        outputs=0xFFFF;
        break;
    }

    if((position > 3) && (position < 10))
    {
        outputs=0x0000;
    }
    else if(position > 10)
    {
        position=0;
        programmfinished=0;
    }

    position++;
    outputupdate=1;
}

/*------------------------------------------------------------------------------
name:           LEDProgramm_14
input:          none
output:         none
description:    this routine puts together the moving light programm
------------------------------------------------------------------------------*/
void LEDProgramm_14(void)
{
    if(position < 3)
    {
        outputs=0x00FF;
    }
    else if((position > 3) && (position < 5))
    {
        outputs=0xFF00;
    }
    else if(position > 5)
    {
        position=0;
        programmfinished=0;
    }

    position++;
    outputupdate=1;
}

/*------------------------------------------------------------------------------
name:           LEDProgramm_15
input:          none
output:         none
description:    this routine puts together the moving light programm
------------------------------------------------------------------------------*/
void LEDProgramm_15(void)
{

    switch(position)
    {
        case 1:
        outputs=0x00FF;
        break;

        case 2:
        outputs=0x0000;
        break;

        case 3:
        outputs=0x00FF;
        break;


        case 4:
        outputs=0xFF00;
        break;

        case 5:
        outputs=0x0000;
        break;

        case 6:
        outputs=0xFF00;
        break;


        case 7:
        outputs=0x00FF;
        break;

        case 8:
        outputs=0x0000;
        break;

        case 9:
        outputs=0x00FF;
        break;


        case 10:
        outputs=0xFF00;
        break;

        case 11:
        outputs=0x0000;
        break;

        case 12:
        outputs=0xFF00;
        break;
    }

    if((position > 12) && (position < 20))
    {
        outputs=0x0000;
    }
    else if(position > 20)
    {
        position=0;
        programmfinished=0;
    }

    position++;
    outputupdate=1;

}

/*------------------------------------------------------------------------------
name:           LEDProgramm_16
input:          none
output:         none
description:    this routine puts together the moving light programm
------------------------------------------------------------------------------*/
void LEDProgramm_16(void)
{
    int tmp;

    if(position==1)
    {
        outputs=0x180;
    }
    else
    {
        tmp=(outputs << 1) & 0xFF00;
        outputs=(outputs >> 1) & 0x00FF;
        outputs=outputs | tmp;

        if (position >= 8)
        {
            position=0;
            programmfinished=0;
        }
    }

    position++;
    outputupdate=1;
}

/*------------------------------------------------------------------------------
name:           LEDProgramm_17
input:          none
output:         none
description:    this routine puts together the moving light programm
------------------------------------------------------------------------------*/
void LEDProgramm_17(void)
{
    if(position==1)outputs=0;

    if(position < 17)
    {
        outputs=outputs + kit[position];
    }
    else if((position > 17) && (position < 33))
    {
        outputs=outputs - kit[position-17];
    }
    else if(position > 33)
    {
        position=0;
        outputs=0;
        programmfinished=0;
    }

    position++;
    outputupdate=1;
}


/*******************************************************************************
 * Info
 *******************************************************************************
 * Changelog:
 * -
 *
 *******************************************************************************
 * Bugs, feedback, questions and modifications can be posted on the
 * C-Control Forum on http://www.c-control.de
 * Of course you can also write us an e-mail to: webmaster@c-control.de
 * We publish updates from time to time on www.c-control.de!
 *******************************************************************************
 * - LICENSE -
 * GNU GPL v2 (http://www.gnu.org/licenses/gpl.txt)
 * This program is free software. You can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
/******************************************************************************/


/*******************************************************************************
Light programms...

1.

    /*
    if(position==1)
        outputs = 0x5555;
    else
    {
        outputs = 0xAAAA;
        if(position >=2)
            position =0;
    }
    position++;
    outputupdate=1;
    */



//EOF