/*** DemoADCapture.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//-----------------------------------------------
// This program requires these other modules and libraries:
// 1. ADCapture.asm
// 2. ADCapture.h
// 3. ADCapture.cc
/*** Please add the required files to your porject! ***/
//------------------------------------------------
 #include "ADCapture.h"
 #define BUFFER_SIZE 128
//------------------------------------------------
 void main(void)
    {
    float f_buffer[BUFFER_SIZE];
    word w_buffer[BUFFER_SIZE];
    byte by_flip_flop;

    ADCaptureInit(ADC_VREF_VCC, ADC_FRQ_115kHz, ADC0);
    by_flip_flop = 1;

    while(1)
        {
        Msg_WriteChar(13);
//------------------------------------------------
/*** Demo ADCaptureSleep() ***/
        ADCaptureSetPrescaler(ADC_FRQ_115kHz);
        ADCaptureSetChannel(ADC0);
        Msg_WriteText("ad-value: ");
        Msg_WriteWord(ADCaptureSleep());
        Msg_WriteChar(13);
        Thread_Delay(300);
//------------------------------------------------
/*** Demo ADCaptureRun(...) ***/
        ADCaptureSetPrescaler(ADC_FRQ_230kHz);
        ADCaptureSetChannel(ADC1);
        ADCaptureRun(w_buffer, BUFFER_SIZE);
        ADCaptureRelease();
        ADCaptureSmooth(w_buffer, BUFFER_SIZE);

        Msg_WriteText("ADCaptureRun(...)\r");
        ADCaptureShowBuffer(w_buffer, BUFFER_SIZE);
        Thread_Delay(300);
//------------------------------------------------
/*** Demo ADCaptureRunFree(...) ***/
        ADCaptureSetPrescaler(ADC_FRQ_460kHz);
        ADCaptureSetChannel(ADC2);
        ADCaptureRunFree(w_buffer, BUFFER_SIZE);
        ADCaptureRelease();
        ADCaptureSmooth(w_buffer, BUFFER_SIZE);

        Msg_WriteText("ADCaptureRunFree(...)\r");
        ADCaptureShowBuffer(w_buffer, BUFFER_SIZE);
        Thread_Delay(300);
//------------------------------------------------
/*** Demo ADCaptureRunQuiet(...) ***/
        ADCaptureSetPrescaler(ADC_FRQ_1_8MHz);
        ADCaptureSetChannel(ADC3);
        ADCaptureRunQuiet(w_buffer, BUFFER_SIZE);
        ADCaptureRelease();
        ADCaptureSmooth(w_buffer, BUFFER_SIZE);

        if(BUFFER_SIZE != Irq_GetCount(INT_ADC))
            Msg_WriteText("ERROR: invalid capture\r");
        else
            {
            Msg_WriteText("ADCaptureRunQuiet(...)\r");
            ADCaptureShowBuffer(w_buffer, BUFFER_SIZE);
            }
            Thread_Delay(300);
//------------------------------------------------
/*** Demo ADCaptureRunFreeFloat(...) ***/
        ADCaptureSetPrescaler(ADC_FRQ_921kHz);
        ADCaptureSetChannel(ADC4);
        ADCaptureRunFreeFloat(f_buffer, BUFFER_SIZE);
        ADCaptureRelease();
        ADCaptureSmoothFloat(f_buffer, BUFFER_SIZE);

        Msg_WriteText("ADCaptureRunFreeFloat(...)\r");
        ADCaptureShowFloatBuffer(f_buffer, BUFFER_SIZE);
        Thread_Delay(300);
//------------------------------------------------
        if(by_flip_flop)
            ADCaptureSetVref(ADC_VREF_BG);
        else
            ADCaptureSetVref(ADC_VREF_VCC);
        by_flip_flop = 1 ^ by_flip_flop;
        }
    }
//------------------------------------------------