/*** DemoPressure.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//-----------------------------------------------
// This program requires these other modules and libraries:
// 1. I2C.h / I2C.cc / I2C.asm
// 2. SensorConditioner.h / SensorConditioner.cc
// 3. Pressure.h / Pressure.cc
/*** Please add the required files to your porject! ***/
//------------------------------------------------
 #define PRESSURE_WRITE_ADDR (0x7B << 1)
//------------------------------------------------
 void main(void)
    {
    char ac_msg[40];
    float f_pressure;

    I2CInitialize(I2C_100kHz, 0x00);

    if(SensorInit(PRESSURE_WRITE_ADDR))
        Msg_WriteText("Pressure-Module -> OK\r");
    else
        Msg_WriteText("Pressure-Module -> ERROR\r");

    PressureSendValues(PRESSURE_WRITE_ADDR, 1);
    Thread_Delay(500);

    while(1)
        {
        f_pressure = PressureRead(PRESSURE_WRITE_ADDR);
        if(INVALID_VALUE != f_pressure)
            {
            Str_Printf(ac_msg, "Luftdruck: %5.2f hPa\r", f_pressure * 10.0);
            Msg_WriteText(ac_msg);
            }
        else
            {
            Msg_WriteText("Luftdruck: Fehler\r");
            SensorInit(PRESSURE_WRITE_ADDR);
            }

        Msg_WriteChar(13);
        Thread_Delay(100);
        }
    }
//------------------------------------------------