/*** Definitions.h ***/
//------------------------------------------------
 #ifndef __DS18S20_VIA_DS2482__
 #define __DS18S20_VIA_DS2482__
//------------------------------------------------
 #define BOOL int
 #define INVALID_VALUE 210.0
 #define MAX_VALUE 100.0
 #define MIN_VALUE -55.0
//------------------------------------------------
/*** Temperature Sensor Definitions ***/
//------------------------------------------------
/*** DS2482 ***/

/*** Status Register ***/
// bit_7 bit_6 bit_5 bit_4 bit_3 bit_2 bit_1 bit_0
// DIR   TSB   SBR   RST   LL    SD    PPD   1WB
// DIR = Branch Direction taken
// TSB = Triplet Second Bit
// SBR = Single Bit Result

// RST = Device Reset
 #define BIT_DEVICE_RESET 4

// LL  = Logic Level
 #define BIT_LOGIC_LEVEL 3

// SD  = Short Detected
 #define BIT_SHORT_DETECT 2

// PPD = Presence-Pulse Detect
 #define BIT_PRESENCE_DETECT 1

// 1WB = 1-Wire Busy
 #define BIT_WIRE_BUSY 0

/*** Configuration Register ***/
// bit_7 bit_6 bit_5 bit_4 bit_3 bit_2 bit_1 bit_0
// 1WS   SPU   PPM   APU   1WS   SPU   PPM   APU

// 1WS = 1-Wire Speed
 #define BIT_1WS 3

// SPU = Strong Pullup
 #define BIT_SPU 2

// PPM = Presence-Pulse Masking
 #define BIT_PPM 1

// APU = Active Pullup
 #define BIT_APU 0

/*** Valid Pointer Codes ***/

// Status Register F0h
 #define CONV_STATUS_REG 0xF0

// Read Data Register E1h
 #define CONV_DATA_REG 0xE1

// Configuration Register C3h
 #define CONV_CONFIG_REG 0xC3

 #define ADDR_CONV_1_WRITE 0x30
 #define ADDR_CONV_1_READ 0x31
 #define ADDR_CONV_2_WRITE 0x32
 #define ADDR_CONV_2_READ 0x33
 #define ADDR_CONV_3_WRITE 0x34
 #define ADDR_CONV_3_READ 0x35
 #define ADDR_CONV_4_WRITE 0x36
 #define ADDR_CONV_4_READ 0x37
 #define CMD_CONV_RESET 0xF0
 #define CMD_CONV_RESET_OW 0xB4
 #define CMD_CONV_CONFIG 0xD2
 #define CMD_CONV_SET_READ_POINTER 0xE1
 #define CMD_CONV_WRITE_BYTE 0xA5
 #define CMD_CONV_READ_BYTE 0x96

//------------------------------------------------
/*** DS1820 ***/

 #define ROM_CODE_SIZE 8
 #define SCRATCHPAD_SIZE 9

/*** Rom commands ***/
 #define CMD_OW_READ_ROM 0x33
 #define CMD_OW_MATCH_ROM 0x55
 #define CMD_OW_SKIP_ROM 0xCC
 #define CMD_OW_SEARCH_ROM 0xF0
 #define CMD_OW_ALARM_SEARCH 0xEC

/*** Memory commands ***/
 #define CMD_OW_READ_SCRATCHPAD 0xBE
 #define CMD_OW_WRITE_SCRATCHPAD 0x4E
 #define CMD_OW_COPY_SCRATCHPAD 0x48
 #define CMD_OW_RECALL_SCRATCHPAD 0xB8
 #define CMD_OW_CONVERT 0x44
 #define CMD_OW_READ_POWER_SUPPLY 0xB4

/*** Scratchpad bytes ***/
 #define BYTE_TEMP_LSB     0
 #define BYTE_TEMP_MSB     1
 #define BYTE_TH           2
 #define BYTE_TL           3
 #define BYTE_RES_1        4
 #define BYTE_RES_2        5
 #define BYTE_COUNT_REMAIN 6
 #define BYTE_COUNT_PER_C  7
 #define BYTE_CRC          8

//------------------------------------------------
/*** I2C address ***/
// A1 = 0; A0 = 0;   0b0011 0000
 #define CONV_ADDR_1 0x30
// A1 = 0; A0 = 1;   0b0011 0010
 #define CONV_ADDR_2 0x32
// A1 = 1; A0 = 0;   0b0011 0100
 #define CONV_ADDR_3 0x34
// A1 = 1; A0 = 1;   0b0011 0110
 #define CONV_ADDR_4 0x36

/*** I2C status codes ***/
 #define I2C_M_START 0x08
 #define I2C_REPEATED_START 0x10
 #define I2C_MT_SLA_ACK 0x18
 #define I2C_MT_SLA_NACK 0x20
 #define I2C_MT_DATA_ACK 0x28
 #define I2C_MT_DATA_NACK 0x30
 #define I2C_MR_SLA_ACK 0x40
 #define I2C_MR_SLA_NACK 0x48
 #define I2C_MR_DATA_ACK 0x50
 #define I2C_MR_DATA_NACK 0x58

//------------------------------------------------
 #endif
//------------------------------------------------