;*** DCF77Time.asm ***;
;-------------------------------------------------
 .include "cpu128def.asm"
;-------------------------------------------------
; 10 ms Timer
; 10 ms = 0.01 s
; 1 / 0.01 = 100 Hz
; 14 734 560 MHz / 100 Hz = 147345,6
; (10 ms = 147345,6 cpu-ticks) / pre_8 = (18418,2 count/ 0x47F2)
;-------------------------------------------------
 .ifdef TagDCF77StartTimer3A
 DCF77StartTimer3A:
    in   R0,   SREG
    cli
; Set OCR3AH and OCR3AL - Output Compare Register 3 A.
    ldi  R22,    0x47
    ldi  R23,    0xF2
    sts  OCR3AH, R22
    sts  OCR3AL, R23
; Set TCCR3A - Timer/Counter3 Control Register A.
    ldi  R22,    0x00
    sts  TCCR3A, R22
; Set TCCR3B - Timer/Counter3 Control Register B.
    ldi  R22,    (1 << WGM32) | (1 << CS31)
    sts  TCCR3B, R22
; ETIMSK - Extended Timer/Counter Interrupt Mask Register
    ldi  R22,    (1 << OCIE3A)
    sts  ETIMSK, R22
    out  SREG, R0
    sei
    ret
 .endif
;-------------------------------------------------