/*** demo.cc ***/
//------------------------------------------------
/*** Keyboard Definitions ***/
 #define KEY_1 8192
 #define KEY_2 8
 #define KEY_3 1
 #define KEY_4 1024
 #define KEY_5 16384
 #define KEY_6 2
 #define KEY_7 4096
 #define KEY_8 256
 #define KEY_9 4
 #define KEY_X 2048
 #define KEY_0 512
// #define KEY_H 32768 // causes error message
//------------------------------------------------
/*** Thread Definitions ***/
 #define THREAD_MAIN 0
 #define THREAD_SWITCH 1
 #define SIG_SWITCH 0x0F
 #thread THREAD_MAIN, 0, 50
 #thread THREAD_SWITCH, 128, 10
//------------------------------------------------
 void ThreadSwitchRelays(void)
    {
    static byte aby_frame_write[FRAME_SIZE] = {NO_OPERATION, CARD_1, 0, 0};
    while(1)
        {
        Thread_Wait(THREAD_SWITCH, SIG_SWITCH);
        Thread_Delay(10);
        switch(Key_Scan())
            {
            case KEY_0:
                aby_frame_write[COMMAND] = SET_PORT;
                aby_frame_write[DATA] = RELAY_NO;
                break;
            case KEY_1:
                aby_frame_write[COMMAND] = TOGGLE;
                aby_frame_write[DATA] = RELAY_1;
                break;
            case KEY_2:
                aby_frame_write[COMMAND] = TOGGLE;
                aby_frame_write[DATA] = RELAY_2;
                break;
            case KEY_3:
                aby_frame_write[COMMAND] = TOGGLE;
                aby_frame_write[DATA] = RELAY_3;
                break;
            case KEY_4:
                aby_frame_write[COMMAND] = TOGGLE;
                aby_frame_write[DATA] = RELAY_4;
                break;
            case KEY_5:
                aby_frame_write[COMMAND] = TOGGLE;
                aby_frame_write[DATA] = RELAY_5;
                break;
            case KEY_6:
                aby_frame_write[COMMAND] = TOGGLE;
                aby_frame_write[DATA] = RELAY_6;
                break;
            case KEY_7:
                aby_frame_write[COMMAND] = TOGGLE;
                aby_frame_write[DATA] = RELAY_7;
                break;
            case KEY_8:
                aby_frame_write[COMMAND] = TOGGLE;
                aby_frame_write[DATA] = RELAY_8;
                break;
            case KEY_9:
                aby_frame_write[COMMAND] = TOGGLE;
                aby_frame_write[DATA] = RELAY_ALL;
                break;
            case KEY_X:
                aby_frame_write[COMMAND] = SET_PORT;
                aby_frame_write[DATA] = RELAY_ALL;
                break;
            default: continue;
            }
        Thread_Lock(1);
        if(!RelayCardSendFrame(aby_frame_write))
            RelayCardClearBuffer();
        Thread_Lock(0);
        }
    }
//------------------------------------------------
 void main(void)
    {
    Key_Init();
    if(RelayCardInit())
        Msg_WriteText("RelayCardInit -> OK\r");
    else
        Msg_WriteText("RelayCardInit -> ERROR\r");
    Thread_Start(THREAD_SWITCH, ThreadSwitchRelays);
    while(1)
        {
        if(Key_Scan())
            Thread_Resume(THREAD_SWITCH);
        Thread_Delay(10);
        }
    }
//------------------------------------------------